#!/bin/bash

. /usr/local/horizon/scripts/hzn-bin.inc
. /usr/local/horizon/scripts/tenantInPathTokenUtil.sh

usage()
{
    echo "usage: $0 [-h vRA Machine Host Name] [-t Tenant Name]"
    echo "  -h vRA Machine Host Name       Host Name of the vRA Machine"
    echo "  -t Tenant Name                 Name of the Tenant to Export"
    exit 1
}

while getopts ":h:t:" o; do
    case "${o}" in
        h)
            HOST=${OPTARG}
            ;;
        t)
            TENANT=${OPTARG}
            ;;
        *|help)
            usage
            ;;
    esac
done

if [ -z "${HOST}" ] || [ -z "${TENANT}" ]; then
usage
fi

HZN_CURL="/usr/local/horizon/bin/curl"


getlocalUsers()
{

LOCAL_USERS="localUsers"
LOCAL_USER_PATH="${BASE_PATH}/${LOCAL_USERS}"
mkdir -p ./"${LOCAL_USER_PATH}"

echo -e "###### Get ${TENANT} local users"
echo { \"attributes\" : \"userName,emails,name,roles\",\"filter\": \"internalUserType eq \\\"LOCAL\\\"\"} > localUsersFilter.json
$HZN_CURL -k -s -X POST -H "Authorization: Bearer $ACCESS_TOKEN" -H "Accept: application/json" -H "Content-Type: application/json" -d@localUsersFilter.json  https://$HOST/SAAS/t/$TENANT/jersey/manager/api/scim/Users/.search/ > "${LOCAL_USER_PATH}/allLocalUsers.json"

rm -f localUsersFilter.json

echo -e "SUCCESS\n"

}

parseAndExtractLocalUsers()
{
echo -e "###### parse and extract local users as json"
localUserJsonFile="${LOCAL_USER_PATH}/allLocalUsers.json"

export TENANT
export TENANT_MANAGEMENT_DATA
export LOCAL_USERS

cat $localUserJsonFile | /usr/bin/python -c 'import sys, json,os;

# load the json into myobj
myobj = json.load(sys.stdin);

resources = myobj["Resources"]

tenant=os.environ["TENANT"]
teantManagementData=os.environ["TENANT_MANAGEMENT_DATA"]
localUsers=os.environ["LOCAL_USERS"]

for item  in resources:
    item.pop("meta",None)
    item.pop("urn:scim:schemas:extension:workspace:1.0",None)
    item.pop("id",None)
    for role in item["roles"]:
        if role["display"]=="Administrator":
            with open(tenant+"/"+teantManagementData+"/"+"administrators.json", "a") as outfile:
             outfile.write(item["userName"]+"\n")
             break
    item.pop("roles",None)
    file=tenant+"/"+item["userName"]+".json";
    item["password"]="Welcome@123";
    with open(tenant+"/"+teantManagementData+"/"+localUsers+"/"+item["userName"]+".json", "a") as outfile:
         json.dump(item, outfile)
    print json.dumps(item, sort_keys=True, indent=4, separators=(",", " : "));'

rm -f $localUserJsonFile

echo -e "SUCCESS\n"

}

exportTenantManangementData()
{

rm -rf ./${TENANT}/
TENANT_MANAGEMENT_DATA="TenantManagementData"
BASE_PATH="${TENANT}/${TENANT_MANAGEMENT_DATA}"
mkdir -p ./"${BASE_PATH}"
TENANT_DATA_FILE="${BASE_PATH}/tenant.json"

if [ "x$DEFAULT_TENANT" = "x$TENANT" ]
 then
    echo -e "##### Default Tenant Already Exists! Extract Only Local Users"
 else
  echo -e "##### Exporting Child Tenant"
$HZN_CURL -k -s  -XGET -H "Authorization: Bearer $ACCESS_TOKEN" "https://$HOST/SAAS/jersey/manager/api/tenants/tenant/$TENANT" > "${TENANT_DATA_FILE}"
TMP="temp.json"
cat $TENANT_DATA_FILE | /usr/bin/python -c 'import sys, json,os;
myobj = json.load(sys.stdin);
myobj.pop("_links",None)
myobj.pop("expirationPeriodInDays",None)
print json.dumps(myobj, sort_keys=True, indent=4, separators=(",", " : "));' > $TMP

if [ -s $TMP ]; then
   cp $TMP $TENANT_DATA_FILE
fi
rm -f $TMP

fi

echo -e "SUCCESS\n"

getlocalUsers
parseAndExtractLocalUsers

}

getAccessToken
exportTenantManangementData