CONF_PATH=${CONF_PATH:-/usr/local/horizon/conf}

FLAG_DIR=${CONF_PATH}/flags
FLAG_GROUP=${TOMCAT_GROUP-www}

if [[ $EUID -eq 0 ]]; then
    if [ ! -d $FLAG_DIR ] ; then
        mkdir -p $FLAG_DIR
    fi

    if [ $(stat -c %G $FLAG_DIR) != $FLAG_GROUP ] ; then
        chown root:$FLAG_GROUP $FLAG_DIR
        chmod 770 $FLAG_DIR
    fi
fi

FLAG_ENABLE_PREFIX=$FLAG_DIR/enable.

FLAG_FIRSTBOOT=$FLAG_DIR/sysconfig.firstboot
FLAG_NETWORK_FIRSTBOOT=$FLAG_DIR/network.firstboot
FLAG_MAC_ADDRESS=$FLAG_DIR/sysconfig.mac_address
FLAG_HOSTNAME=$FLAG_DIR/sysconfig.hostname

FLAG_OWNDB=$FLAG_DIR/sysconfig.owndb
FLAG_OWNVA=$FLAG_DIR/sysconfig.ownva
FLAG_OWNIPTABLES_FIREWALL=$FLAG_DIR/sysconfig.owniptables.firewall
FLAG_OWNIPTABLES_FORWARD=$FLAG_DIR/sysconfig.owniptables.forward
FLAG_OWNRABBITMQ=$FLAG_DIR/sysconfig.ownrabbitmq
FLAG_OWNELASTICSEARCH=$FLAG_DIR/sysconfig.ownelasticsearch

FLAG_TOMCAT_MIGRATION=$FLAG_DIR/tomcat.migration
FLAG_FIPS_MODE=$FLAG_DIR/fips.mode
FLAG_FIPS_MODE_DISABLED=$FLAG_DIR/fips.mode.disabled

#Manage sshd access ( only applicable if OWNVA is also set )
FLAG_OWNSSHD=$FLAG_DIR/sysconfig.ownsshd

# this file persists for one boot cycle only
FLAG_CLONE=$FLAG_DIR/sysconfig.iamaclone
FLAG_CLONE_PREP=$FLAG_DIR/sysconfig.cloneprep

FLAG_IDM_INSTALLED=$FLAG_DIR/sysconfig.idminstalled
FLAG_CONNECTOR_INSTALLED=$FLAG_DIR/sysconfig.connectorinstalled
FLAG_LES_INSTALLED=$FLAG_DIR/sysconfig.lesinstalled

FLAG_DATACENTER_ID=$FLAG_DIR/sysconfig.datacenterid
FLAG_NO_DATACENTER=$FLAG_DIR/sysconfig.nodatacenter

FLAG_TELEMETRY=$FLAG_DIR/sysconfig.telemetry

function getEnableFlag(){
  echo ${FLAG_ENABLE_PREFIX}${1}
}

function isConnectorOnly(){
  if [ ! -f $FLAG_IDM_INSTALLED -a -f $FLAG_CONNECTOR_INSTALLED ]; then
    return 0
  fi
  return 1
}
