#!/bin/bash

rm horizon-init1.py
PYTHON_SCRIPT=horizon-init1.py
cat>>${PYTHON_SCRIPT}<<EOF
#! /usr/bin/env python
# Copyright VMware, Inc. All rights reserved. -- VMware Confidential
import sys
import json
import urllib
import urllib2
import urlparse
import argparse
import httplib
import ssl
import requests
import re
# The goal of this tool is to setup Horizon service and make the neccessary configurations so it can be used as
# identity provider for a multi tenant enabled vRA.
#
# Here are the actions it is performing currently:
# - Creates default tenant
# - Configure Horizon multi tenant support
#   - disable single tenant mode
#   - enable child orgs creation
# - Enable login from local users including default tenant operator user (admin)
#   - enable_local_users_support()
#   - enable_local_users_auth()
# - Activate first connector
# - Update user attribute definitions

# Routines

FIRST_CONNECTOR_NAME = 'first.connector'
session = ''

#Initialize SystemConfig File

# =====================
# Initialize SystemConfig File
def populateSysconfig():
    global configSession
    global hostname
    configSession = requests.Session()
    try:
        # get xsrf token
        response = do_http_call(":8443/cfg/login", None, 'GET')
        # verifyResponseIsOk(response)
        print response.text
        xsrfToken = getXsrfToken(response.text)
        data = {
	    'username': 'admin',
	    'password': password
	}
	response = do_http_call(":8443/cfg/j_security_check", data, 'POST')
	hznAdminToken = configSession.cookies['HZN_ADMIN']
	configSession.headers.update({'X-Vk': xsrfToken})
        configSession.headers.update({'x-tenant-id': tenant})
        configSession.headers.update({'admin-password': password})
        configSession.headers.update({'HZN_ADMIN': hznAdminToken})
	formData = {}
        response = do_http_call(":8443/cfg/diagnostic/sysconfig",formData,'GET')
        print response.text
    # verifyResponseIsOk(response)
    except urllib2.HTTPError as e:
        print "ERROR: Cannot find the default tenant state. Response: '{0}' ({1})".format(e.code, e.msg)
        return False
#def populateConfig():

def getXsrfToken(responseText):
    match = re.search(r'window.ec_wiz.vk = \'(\w+)\'', responseText)
    print(match.group(1))
    xsrfToken =  str(match.group(1))
    return xsrfToken

def do_http_call2(session, url, data=None, verb='GET', headers={}, accept=None, host=None, parseAsJson=False):
    global configSession
    response = configSession.request(verb, url, data=data, headers=headers)
    return response
#======================

def do_http_call(endpoint, data=None, verb='GET',
                 content_type='application/x-www-form-urlencoded', accept=None, host=None, parseAsJson=False):
    global configSession
    global hostname

    host = host if host else hostname
    url = 'https://%s%s' % (host, endpoint)

    if DEBUG:
        print
        "DEBUG: request %s %s" % (verb, url)
        print
        "DEBUG: Content-Type %s" % (content_type)
        print
        "DEBUG: Accept %s" % (accept)
        print
        "DEBUG: data %s" % (data)

    response = configSession.request(verb, url, data=data, verify=False)

    return response


# =====================

# =====================

def is_default_tenant_initialized():
    try:
        ## TODO use new API for this call
        response = do_rest_call("/SAAS/t/%s/API/1.0/REST/system/bootstrap/initialize" % tenant)
        data = response['content']
        initialized = data['initialized'] in ['true', 'True']
        print 'Default tenant is initialized:', initialized
        return initialized
    except urllib2.HTTPError as e:
        print "ERROR: Cannot find the default tenant state. Response: '{0}' ({1})".format(e.code, e.msg)
        return False

#=====================
def create_default_tenant():
    if is_default_tenant_initialized():
        return

    print "\n### Init default tenant/organization."

    jdata = json.dumps({
        "name": tenant,
        "adminUserName": username,
        "adminPassword": password,
        "adminFirstName": "hznAdminFirstName",
        "adminLastName": "hznAdminLastName",
        "adminEmail": '%s@%s%s' % (username, hostname, '' if '.' in hostname else '.local')
        })

    try:
        response = do_rest_call("/SAAS/jersey/manager/api/tenants/tenant", jdata, 'POST',
            content_type=get_horizon_content_type('tenants.firsttenant'),
            accept=get_horizon_content_type('tenants.tenant'))
    except urllib2.HTTPError as e:
        print "ERROR: Cannot init default tenant. Response: '{0}' ({1})".format(e.code, e.msg)
        sys.exit(1)

    print "SUCCESS"

#=====================
def login_user(username, password, gateway_hostname):
    global session

    print "\n### Login user: " + username
    jdata = json.dumps({"username":username, "password":password, "issueToken":"true"})
    try:
        response = do_rest_call("/SAAS/t/%s/API/1.0/REST/auth/system/login" % tenant, jdata, 'POST', host=gateway_hostname)

        data = response['content']
        session = data['sessionToken']
        print "the session is " + session
    except urllib2.HTTPError as e:
        print "ERROR: Invalid credentials. Response: '{0}' ({1})".format(e.code, e.msg)
        sys.exit(4)
    print "SUCCESS"

#=====================
def disable_single_tenant_mode(gateway_hostname):
    print "\n### Disable single tenant mode."

    jdata = json.dumps({"name":"isServiceSingleTenant","values":{"values":["false"]}})
    try:

        response = do_rest_call("/SAAS/jersey/manager/api/system/config/isServiceSingleTenant", jdata, 'PUT', content_type=get_horizon_content_type('systemconfigparameter'), host=gateway_hostname)
    except urllib2.HTTPError as e:
        print "ERROR: Disable single tenant mode failed. Response: '{0}' ({1})".format(e.code, e.msg)
        sys.exit(1)
    print "SUCCESS"

#=====================
def enable_advanced_user_role(gateway_hostname):
    print "\n### Enable advanced user role feature."

    jdata = json.dumps({"name":"isAdvancedUserRoleFeatureEnabled","values":{"values":["true"]}})
    try:
        response = do_rest_call("/SAAS/jersey/manager/api/system/config/isAdvancedUserRoleFeatureEnabled", jdata, 'PUT', content_type=get_horizon_content_type('systemconfigparameter'), host=gateway_hostname)
    except urllib2.HTTPError as e:
        print "ERROR: Enable advanced user role feature failed. Response: '{0}' ({1})".format(e.code, e.msg)
        sys.exit(1)
    print "SUCCESS"

#=====================
def enable_tenant_features(gateway_hostname):
    print "\n### Enable tenant features."
    jdata = json.dumps({
            'items': [
                    { 'name' : 'orgAllowCreateOrgs', 'value' : 'true' },
                    { 'name' : 'orgEnableWSAdmin', 'value' : 'true' },
                    { 'name' : 'orgEnableUserDomainUniqueness', 'value' : 'true' },
                    { 'name' : 'orgEnableGroupDomainUniqueness', 'value' : 'true' },
                    { 'name' : 'orgFallbackWhenUserNotFoundInIdentifierBasedLoginFlow', 'value' : 'true' },
                    { 'name' : 'orgEnableGroupMembershipComputationDuringSync', 'value' : 'false' },
                    { 'name' : 'showDomainSelectionForAmbiguousIdentifier', 'value' : 'true' }
                ]
            })
    try:
        response = do_rest_call("/SAAS/jersey/manager/api/tenants/tenant/" + tenant + "/config", jdata, 'PUT',
             content_type=get_horizon_content_type('tenants.tenant.config.list'), host=gateway_hostname)
    except urllib2.HTTPError as e:
        print "ERROR: Enable tenant features failed. Response: '{0}' ({1}).".format(e.code, e.msg)
        sys.exit(1)
    print "SUCCESS"

#=====================
def enable_local_users_support(gateway_hostname):
    print "\n### Enable local users support."

    # Note: Horizon will be removing this setting at some point. For now it is required to be set to true
    jdata = json.dumps({"name":"isLocalUserSupportEnabaled","values":{"values":["true"]}})

    try:
        response = do_rest_call("/SAAS/jersey/manager/api/system/config/isLocalUserSupportEnabaled", jdata, 'PUT', content_type=get_horizon_content_type("systemconfigparameter"), host=gateway_hostname)
    except urllib2.HTTPError as e:
        print "ERROR: Enable local user support failed. Response: '{0}' ({1})".format(e.code, e.msg)
        sys.exit(1)
    print "SUCCESS"

#=====================
def find_local_users_store_uuid(gateway_hostname):
    print "\n### Find local users store."

    try:
        response = do_rest_call('/SAAS/jersey/manager/api/localuserstore', None, 'GET', content_type=get_horizon_content_type('local.userstore'), host=gateway_hostname)

        data = response['content']
        return data['uuid']
    except urllib2.HTTPError as e:
        print "ERROR: Finding local users store failed. Response: '{0}' ({1})".format(e.code, e.msg)
        system.exit(1)
    print "SUCCESS"

#=====================
def enable_local_users_auth(gateway_hostname):
    print "\n### Enable local users authentication."

    uuid = find_local_users_store_uuid(gateway_hostname)

    # Both parameters 'userStoreNameUsedForAuth' and 'showLocalUserStore' should be set to true.
    jdata = json.dumps({'uuid':uuid, 'name':'vsphere.local', 'userStoreNameUsedForAuth':'true', 'showLocalUserStore':'true'})
    try:
        response = do_rest_call('/SAAS/jersey/manager/api/localuserstore', jdata, 'PUT', content_type=get_horizon_content_type('local.userstore'), host=gateway_hostname)
    except urllib2.HTTPError as e:
        print "ERROR: Enable local user authentication failed. Response: '{0}' ({1})".format(e.code, e.msg)
        sys.exit(1)
    print "SUCCESS"

#=====================
def get_first_connector(gateway_hostname):
    print "\n### Get first connector."
    try:
        response = do_rest_call("/SAAS/jersey/manager/api/connectormanagement/connectors",
                accept=get_horizon_content_type('connector.management.connector.list'), host=gateway_hostname)
        connectors_data = response['content']
    except urllib2.HTTPError as e:
        print "ERROR: Cannot list connectors. Response: '{0}' ({1} :: {2})".format(e.code, e.msg, (e.read() if DEBUG else ''))
        return None

    connectors = connectors_data['items']
    print "Found %s connectors" % len(connectors)

    for connector in connectors:
        if connector['name'] == FIRST_CONNECTOR_NAME:
            print "Found the first connector."
            return connector

    print "No first connector."
    return None

#=====================
def activate_first_connector(gateway_hostname):
    global connector_hostname
    global tenant

    connector_data = get_first_connector(gateway_hostname)
    if connector_data == None:
        print "\n### Create first connector."

        jdata = json.dumps({
                "name": (FIRST_CONNECTOR_NAME),
            })
        try:
            response = do_rest_call("/SAAS/jersey/manager/api/connectormanagement/connectors", jdata, 'POST',
                    content_type=get_horizon_content_type('connector.management.connector'), host=gateway_hostname)
            connector_data = response['content']
        except urllib2.HTTPError as e:
            print "ERROR: Cannot create connector. Response: '{0}' ({1})".format(e.code, e.msg)
            sys.exit(1)
        print "SUCCESS"

    connector_uuid = connector_data['uuid']

    print "First connector %s activation status %s." % (connector_uuid, connector_data['activationStatus'])
    if connector_data['activationStatus'] == 'ACTIVATED':
        print "SUCCESS"
    else:
        print "\n### Get connector activation token."
        # GET https://<host>

        try:
            response = do_rest_call("/SAAS/jersey/manager/api/connectormanagement/connectors/%s/generateactivationtoken" % connector_uuid,accept=get_horizon_content_type('connector.management.connectorActivationToken'), host=gateway_hostname)
            data = response['content']
        except urllib2.HTTPError as e:
            print "ERROR: Cannot get activation token. Response: '{0}' ({1} :: {2})".format(e.code, e.msg, (e.read() if DEBUG else ''))
            return False

        activation_token = data['activationToken']
        print "SUCCESS"

        print "\n### Activate the first connector using the activation token."

        jdata = json.dumps({
                "activationToken" : activation_token,
                "adminPassword" : password
            })
        try:
            # post on the connector url
            response = do_rest_call("/hc/API/1.0/REST/connectormanagement/connector/activate/", jdata, 'POST',
                    host=connector_hostname, content_type=get_horizon_content_type('connector.management.activate.connector'))
            data = response['content']
        except urllib2.HTTPError as e:
            print "ERROR: Cannot activate first connector ({2}). Response: '{0}' ({1} :: {3})".format(e.code, e.msg, connector_hostname, (e.read() if DEBUG else ''))
            sys.exit(1)

        print "SUCCESS isSuccess: %s, message: %s" % (data['isSuccess'], data['message'])

#=====================
def update_user_attribute_defs(gateway_hostname):
    print "\n### Update user attribute definitions."

    # Constants
    FIRST_NAME_ATTR_DEF = "firstName"
    LAST_NAME_ATTR_DEF = "lastName"
    EMAIL_ATTR_DEF = "email"
    MANAGER_ATTR_DEF = "manager"
    DISPLAY_NAME_ATTR_DEF = "displayName"

    try:
        response = do_rest_call('/SAAS/jersey/manager/api/vidm/userattributedefinitions',
        content_type=get_horizon_content_type("vidm.userattributedefinitions.list"), host=gateway_hostname)
        data = response['content']

        # is updated?
        updated = False
        # Is there a "manager" user attribute already?
        has_manager = False
        # Is there a "displayName" user attribute already?
        has_displayName = False
        for item in data['items']:
                name = item['name']
                # Make "firstName", "lastName", "email", "manager" and "displayName" user attributes optional.
                if name in [FIRST_NAME_ATTR_DEF, LAST_NAME_ATTR_DEF, EMAIL_ATTR_DEF, MANAGER_ATTR_DEF, DISPLAY_NAME_ATTR_DEF]:
                        if item['required'] == True:
                            item['required'] = False
                            updated = True
                if name == MANAGER_ATTR_DEF:
                        has_manager = True
                if name == DISPLAY_NAME_ATTR_DEF:
                        has_displayName = True

        if not has_manager:
                # Add an optional "manager" attribute.
                data['items'].append({"name": MANAGER_ATTR_DEF, "label": "Manager", "required": False })
                updated = True

        if not has_displayName:
                # Add an optional "displayName" attribute.
                data['items'].append({"name": DISPLAY_NAME_ATTR_DEF, "label": "Display Name", "required": False })
                updated = True

        jdata = json.dumps(data)

        # Update the user attributes
        if updated:
                response = do_rest_call('/SAAS/jersey/manager/api/vidm/userattributedefinitions', jdata, 'PUT', content_type=get_horizon_content_type("vidm.userattributedefinitions.list"),host=gateway_hostname)
    except urllib2.HTTPError as e:
        print "ERROR: Update user attribute defs failed. Response: '{0}' ({1})".format(e.code, e.msg)
        sys.exit(1)
    print "SUCCESS"

#=====================
def logout(gateway_hostname):
    global session

    print "\n### Logout."
    try:
        response = do_rest_call("/SAAS/API/1.0/REST/auth/logout", verb='DELETE', host=gateway_hostname)
    except urllib2.HTTPError as e:
        print "WARNING: Logout failed ({0})".format(e.code)
    session = None
    print "SUCCESS"

class NoRedirectHandler(urllib2.HTTPRedirectHandler):
    def redirect_request(self, req, fp, code, msg, headers, newurl):
        return None

#=====================
def get_horizon_content_type(horizon_content_type):
    return "application/vnd.vmware.horizon.manager.{0}+json".format(horizon_content_type)

#=====================
def init_ssl_context():
    global sslcontext_inited
    global sslcontext

    if not sslcontext_inited:
        sslcontext = None
        try:
            sslcontext = ssl.create_default_context()
            sslcontext.check_hostname = False
            sslcontext.verify_mode = ssl.CERT_NONE
        except AttributeError as e:
            # this is defined only in python 2.7.9+
            sslcontext = None
        sslcontext_inited = True

#=====================
def do_rest_call(endpoint, data=None, verb='GET', content_type='application/json', accept=None, host=None, parseAsJson=True):
    host = host if host else hostname
    url = 'https://%s%s' % (host, endpoint)

    init_ssl_context()

    if sslcontext:
        httpsHndl = urllib2.HTTPSHandler(context=sslcontext)
    else:
        httpsHndl = urllib2.HTTPSHandler()

    opener = urllib2.build_opener(httpsHndl, NoRedirectHandler)
    request = urllib2.Request(url, data)

    # Do we have a valid open session?
    if session:
        request.add_header('Authorization', 'HZN ' + session)
    # Do we want a specific accept?
    if accept == None:
        accept = content_type
    request.add_header('Accept', accept)
    request.add_header('Content-Type', content_type)

    # Set the requested HTTP verb.
    request.get_method = lambda: verb

    if DEBUG:
        print "DEBUG: request %s %s" % (verb, url)
        print "DEBUG: Content-Type %s" % (content_type)
        print "DEBUG: Accept %s" % (accept)
        print "DEBUG: data %s" % (data)

    response = opener.open(request)

    # Prepare the returned result.
    status_code = response.getcode()
    content = response.read()

    if DEBUG:
        print "DEBUG: status_code=%s" % status_code
        print "DEBUG: content=%s" % content

    if content and parseAsJson:
        content = json.loads(content)
    result = {'status_code': status_code, 'content': content}

    return result

# Main body
parser = argparse.ArgumentParser()
parser.add_argument('--host', required=True, help='SSO host to connect (usually same as vRA hostname or LB hostname).')
parser.add_argument('--connector-host', required=False, help='Hostname to be used for the first connector (usually the VA hostname).')
parser.add_argument('--user', '--username', '-u', required=True, help='SSO admin user (admin).')
parser.add_argument('--password', '-p', required=True, help='SSO admin password.')
parser.add_argument('--tenant', '-t', required=True, help='SSO system tenant.')
parser.add_argument('--debug', '-d', action='store_const', const=True, default=False, required=False, help='Debug mode.')
parser.add_argument('--tenant_hostname', '-i', required=True, help='Hostname of tenant.')

args = parser.parse_args()

hostname = args.host
username = args.user
password = args.password
tenant = args.tenant
DEBUG = args.debug
tenant_hostname = args.tenant_hostname
configSession = None
session = None
sslcontext = None
sslcontext_inited = False
connector_hostname = "%s:8443" % (tenant_hostname)
jdbcurl = 'blr-2nd-1-dhcp459.eng.vmware.com'
dbUsername = 'admin'
dbPassword = 'adminpassword'
internalDB = True



# Main flow start here
create_default_tenant()
login_user(username, password, hostname)
disable_single_tenant_mode(hostname)
enable_advanced_user_role(tenant_hostname)
enable_tenant_features(tenant_hostname)
enable_local_users_support(tenant_hostname)
enable_local_users_auth(tenant_hostname)
activate_first_connector(tenant_hostname)
update_user_attribute_defs(tenant_hostname)
#populateSysconfig()
logout(tenant_hostname)

EOF

SSH_USER_PASSWORD=vmware

SCRIPTS_PATH=/usr/local/horizon/scripts

#Uncommet this block in jenkins
#cp -R /home/jenkins/jenkins/workspace/vra8-scripts/. .

sshpass -p ${SSH_USER_PASSWORD} scp -o StrictHostKeyChecking=no 25horizon 20vcac horizon-conf root@$1:/usr/local/horizon/scripts
sshpass -p ${SSH_USER_PASSWORD} ssh -o StrictHostKeyChecking=no root@$1 "echo 'components.tenancy.tenantIdInRequestPath=false' >>/usr/local/horizon/conf/runtime-config.properties"
sshpass -p ${SSH_USER_PASSWORD} ssh -o StrictHostKeyChecking=no root@$1 "bash -x ${SCRIPTS_PATH}/20vcac"
sshpass -p ${SSH_USER_PASSWORD} ssh -o StrictHostKeyChecking=no root@$1 "bash -x ${SCRIPTS_PATH}/25horizon"
sshpass -p ${SSH_USER_PASSWORD} ssh -o StrictHostKeyChecking=no root@$1 "echo adminpassword | bash -x ${SCRIPTS_PATH}/horizon-conf"
sshpass -p ${SSH_USER_PASSWORD} ssh -o StrictHostKeyChecking=no root@$1 "echo '$1 $2' >> /etc/hosts"
chmod 777 ${PYTHON_SCRIPT}


./${PYTHON_SCRIPT} --debug \
--host "blr-2nd-1-dhcp459.eng.vmware.com" --connector-host "blr-2nd-1-dhcp459.eng.vmware.com" \
--user "admin" --password "adminpassword" \
--tenant "default-org" --tenant_hostname "default-org.eng.vmware.com"
