#!/bin/bash
#
# Copyright 2016 VMware, Inc. All rights reserved.
#
# This script is used to start/stop/restart java processes
# in horizon services.

function usage() {
    echo "starts / stops / restarts / status java process of a horizon service"
    echo "Usage: $0 <command>"
    echo "     command: start | stop | restart | status"
    echo "     --help displays this message"
    echo
    exit 1
}

COMMAND_ACTION="$1"

case $COMMAND_ACTION in
    start|stop|restart|status)
        service horizon-workspace $COMMAND_ACTION
        ;;
    --help)
        usage
        ;;
    *)
        echo "Invalid command"
        usage
        ;;
esac
