#!/bin/bash

BASE_PATH="/usr/local/horizon/DatabaseConfig"

function dropExistingSchema()
{

 echo "Dropping existing saas schema..."
 db_pwd=`cat /usr/local/horizon/conf/db.pwd`
 export PGPASSWORD=$db_pwd
 /opt/vmware/vpostgres/current/bin/psql -U postgres -d saas -c "DROP schema saas CASCADE"

}

function updateHorizonUserPassword()
{

 echo "Updating horizon user password..."
 vra_db_pwd=`cat ${BASE_PATH}/db.pwd`
 /opt/vmware/vpostgres/current/bin/psql -U postgres -d saas -c "ALTER USER horizon with password '$vra_db_pwd';"

}

function createSchemaAndImportDatabaseDump()
{
  echo "Creating saas database schema..."
  /opt/vmware/vpostgres/current/bin/psql -U postgres saas < ${BASE_PATH}'/createSchema-extensions.sql'

  echo "Importing database dump..."
  vra_db_pwd=`cat ${BASE_PATH}/db.pwd`
  export PGPASSWORD=$vra_db_pwd
  /opt/vmware/vpostgres/current/bin/psql -U horizon saas < ${BASE_PATH}'/vra.sql'

}

dropExistingSchema
updateHorizonUserPassword
createSchemaAndImportDatabaseDump
