#!/bin/bash

. /usr/local/horizon/scripts/tenantInHostTokenUtil.sh


usage()
{
    echo "usage: $0 [-h Tenant Host Name] [-t Tenant Name]"
    echo "  -h Tenant Host Name            Host Name of the Tenant"
    echo "  -t Tenant Name                 Name of the Tenant to Import"
    exit 1
}

while getopts ":h:t:" o; do
    case "${o}" in
        h)
            HOST=${OPTARG}
            ;;
        t)
            TENANT=${OPTARG}
            ;;
        *|help)
            usage
            ;;
    esac
done

if [ -z "${HOST}" ] || [ -z "${TENANT}" ]; then
usage
fi

HZN_CURL="/usr/local/horizon/bin/curl"

importLocalUsers()
{
echo -e "#### Perform Import of Local Users\n"
localUserFiles=`ls ${BASE_PATH}/localUsers/*`
for file in $localUserFiles
 do
  $HZN_CURL -k -s -X POST -H "Authorization: Bearer $ACCESS_TOKEN" -H "Accept: application/json" -H "Content-Type: application/json" -d@$file  https://$HOST/SAAS/jersey/manager/api/scim/Users
 done
 echo -e "SUCCESS\n\n"
}

promoteToAdmin()
{
echo -e "#### Perform Promote Local Users to Admin\n"
administrators=`cat ${BASE_PATH}/administrators.json`

$HZN_CURL -k -s  -XGET -H "Authorization: Bearer $ACCESS_TOKEN" https://$HOST/SAAS/jersey/manager/api/scim/Roles?filter=displayName%20eq%20%22Administrator%22 > "id.json"

DATA_FILE="id.json"
ADMIN_UUID=`cat $DATA_FILE | /usr/bin/python -c 'import sys, json,os;
myobj = json.load(sys.stdin);
resources = myobj["Resources"]
for item  in resources:
    print item["id"];'`

echo "Administrator  UUID : $ADMIN_UUID"
rm -f id.json


for user in $administrators
do

echo { \"attributes\" : \"id\",\"filter\" : \"userName eq \\\"$user\\\" and internalUserType eq \\\"LOCAL\\\"\"} > user.json
$HZN_CURL -k -s -X POST -H "Authorization: Bearer $ACCESS_TOKEN" -H "Accept: application/json" -H "Content-Type: application/json" -d@user.json  https://$HOST/SAAS/jersey/manager/api/scim/Users/.search/ > "id.json"

DATA_FILE="id.json"
UUID=`cat $DATA_FILE | /usr/bin/python -c 'import sys, json,os;
myobj = json.load(sys.stdin);
resources = myobj["Resources"]
for item  in resources:
    print item["id"];'`

echo "User UUID : $UUID"
rm -f user.json
rm -f id.json

echo { \"schemas\": [ \"urn:scim:schemas:core:1.0\"],\"members\" :[{\"value\" : \"$UUID\",\"type\" : \"User\"}]} > admin.json
$HZN_CURL -k -s -X PATCH -H "Authorization: Bearer $ACCESS_TOKEN" -H "Accept: application/json" -H "Content-Type: application/json" -d@admin.json  https://$HOST/SAAS/jersey/manager/api/scim/Roles/$ADMIN_UUID
rm -f admin.json
done

echo -e "\nSUCCESS\n\n"

}

createTenant()
{
echo -e "#### Perform Import of Child Tenant \n"
DATA_FILE=`ls ${BASE_PATH}/tenant.json`
$HZN_CURL -k -s -X POST -H "Authorization: Bearer $ACCESS_TOKEN" -H "Content-Type: application/vnd.vmware.horizon.manager.tenants.tenant+json" -d@$DATA_FILE  https://$HOST/SAAS/jersey/manager/api/tenants/tenant
echo -e "\nSUCCESS\n\n"

}

importTenant()
{

TENANT_MANAGEMENT_DATA="TenantManagementData"
BASE_PATH="${TENANT}/${TENANT_MANAGEMENT_DATA}"
DEFAULT_TENANT="vsphere.local"

if [[ "$TENANT" == "$DEFAULT_TENANT" ]]; then
  echo -e "#### Default Tenant is already Exists! Import only Local Users \n"
 else
  createTenant
  HOST=$TENANT_HOST
  echo -e "TENANT HOST : $HOST\n"
fi

importLocalUsers
promoteToAdmin

}


getAccessToken
importTenant
