#!/bin/sh
PORT_REDIRECT_DIR=/usr/local/horizon/conf/port-redirects

. /usr/local/horizon/scripts/distroSpecific.inc

# Redirect traffic from lower ports to higher ports as specified in port redirection config files
# so that processes can be run as a non-privileged user.

# Packages register for this service by creating a mapping file in the PORT_REDIRECT_DIR that has a triple
# on each line consisting of:
#   protocol lower-port upper-port
# where protocol can be tcp or udp. The file may also contain comments that beginning with a #.

# This script processes all files in that directory.
# If the script is called with an option, then the rules are flushed and an extra entry is added to map
# the IP address for the default VAMI interface (or eth0 if that is not defined)

# IPV6 port forwarding is NOT supported with the current installed version of ip6tables

. /usr/local/horizon/scripts/flag.inc
if [ ! -f $FLAG_OWNIPTABLES_FORWARD ] ; then
  exit 0
fi

#drop all current rules
${IPTABLES} -t nat --flush

IFC=eth0
if test -e /opt/vmware/share/vami/vami_default_interface ; then
    IFC=`/opt/vmware/share/vami/vami_default_interface`
fi
IP=`/sbin/ip -o -f inet addr show dev ${IFC} | awk '{ print $4 }'| sed -e 's/\/.*$//'`

# process all files or symbolic links in $PORT_REDIRECT_DIR
for file in `find $PORT_REDIRECT_DIR ! -type d`
do
    grep -v '^#' $file | while read protocol lower higher
    do
        #Local but not using loopback
        ${IPTABLES} -t nat -I OUTPUT -p ${protocol} -d ${IP} --dport ${lower} -j REDIRECT --to-ports ${higher}

        #loopback support
        ${IPTABLES} -t nat -I OUTPUT -p ${protocol} -d 127.0.0.1 --dport ${lower} -j REDIRECT --to-ports ${higher}

        #external
        ${IPTABLES} -t nat -I PREROUTING -p ${protocol} --dport ${lower} -j REDIRECT --to-ports ${higher}
    done
done

