#!/bin/bash
# Script to enable feature flags
. /usr/local/horizon/scripts/hzn-bin.inc

TENANT_ID="vsphere.local"

HOST="$TENANT_ID."`hostname -f | cut -f 2,3,4,5,6  -d '.'`

if [ "x$HOST" = "x" ]
then
   echo Hostname is required, e.g. tenant.example.com.
   exit 1
fi

echo "Please enter the admin account name for vsphere.local tenant"
read ADMIN_ACCOUNT

if [ "x$ADMIN_ACCOUNT" = "x" ]
then
   echo Admin username is required.
   exit 1
fi

echo "Please enter the admin password , This is required to enable feature flags"
read -s ADMINPASSWORD
if [ "x$ADMINPASSWORD" = "x" ]
then
   echo Admin password is required.
   exit 1
fi


check_restart()
{
  echo "Waiting for the server to restart"
  TIMEOUT=0
  FLAG=0
  while [ $FLAG -eq 0 ]
  do
  sleep 1
  grep "Server startup" /opt/vmware/horizon/workspace/logs/catalina.log > /dev/null
  if [ $? -eq 0 ]
  then
    echo Restart complete.
    sleep 5
    FLAG=1
  fi
  TIMEOUT=`expr $TIMEOUT + 1`
  if [ $TIMEOUT -ge 360 ]
  then
     echo Server did not startup. Exiting.
     exit 1
  fi
  done
}

login()
{
echo -e "\n================ Get Auth Cookie ================== "
  echo {\"username\":\"$ADMIN_ACCOUNT\", \"password\":\"${ADMINPASSWORD}\", \"issueToken\":\"true\"} > login.json
AUTH_COOKIE=`curl -k -s -X POST -H "Accept: application/json" -H "Content-Type: application/json" -d@login.json https://$HOST/SAAS/API/1.0/REST/auth/system/login | cut -f 3 -d : | sed -e "s/\"//g" -e "s/,.*//"`
  if [ "x$AUTH_COOKIE" = "x" ]
  then
      echo "Could not fetch the auth cookie, make sure you entered correct password"
      echo "Please check connection to host ${HOST} or make sure you entered correct password"
      exit 1
  fi
  rm login.json
  echo -e "\n AUTH_COOKIE :  $AUTH_COOKIE \n"
}


add_flags()
{
echo -e "\n================ updating orgEnableGroupMembershipComputationDuringSync flag =================="
cat > flag.json << _EOF_
{
   "items":[
      {
         "name": "orgEnableGroupMembershipComputationDuringSync",
         "value": "true"
      }
   ]
}
_EOF_

curl -s -X PUT -H "Content-Type: application/vnd.vmware.horizon.manager.tenants.tenant.config.list+json" -H "Accept: application/vnd.vmware.horizon.manager.tenants.tenant.config.list+json" -H "Authorization: HZN $AUTH_COOKIE" -d@flag.json https://$HOST/SAAS/jersey/manager/api/tenants/settings?tenantId=${TENANT_ID}
echo -e "\n"
}

updateEndUserCatalogUrl()
{
echo -e "\n================ updating endUserCatalogUrl ================== \n"

echo {\"values\": {\"values\": \[\"https://$HOST:443/catalog-portal\"]}, \"name\": \"endUserCatalogUrl\"} > endUserCatalogUrl.json

curl -s -X PUT -H "Content-Type: application/vnd.vmware.horizon.manager.systemconfigparameter+json" -H "Accept: application/vnd.vmware.horizon.manager.systemconfigparameter+json" -H "Authorization: HZN $AUTH_COOKIE" -d@endUserCatalogUrl.json https://$HOST/SAAS/jersey/manager/api/system/config/endUserCatalogUrl
echo -e "\n"
}

enable_gb()
{
   echo -e "\n================ enabling Green Box ==================\n"
   curl -k -XGET -H "Authorization: HZN $AUTH_COOKIE" https://$HOST/SAAS/jersey/manager/api/commoncatalog/enable
   if [ $? -eq 0 ]
   then
       echo "End user portal has been enabled"
   fi
}

create_tenants_in_gb()
{
#Create Tenants in Green Box
for TENANT in `ls "/usr/local/horizon/conf/states/"`; do
   echo -e "\n================ Creating Tenant $TENANT in Green Box ==================\n"
   curl -s -X POST -H "Content-Type: application/json" -H "Accept: application/json" -H "Authorization: HZN $AUTH_COOKIE" https://$HOST/SAAS/jersey/manager/api/tenants/greenbox?tenants=${TENANT}
   echo -e "\n"
done

echo -e "\n================ restarting horizon service ==================\n"
}

check_restart
login
add_flags
updateEndUserCatalogUrl
create_tenants_in_gb