#!/bin/sh

. /usr/local/horizon/scripts/manageTcCfg.inc

JRE_HOME=/usr/java/jre-vmware
JRE_KEYTOOL=${JRE_HOME}/bin/keytool
JRE_CA_CERTS=${JRE_HOME}/lib/security/cacerts
JRE_CA_PASS=changeit

CONF_DIR=${CONF_DIR:-/usr/local/horizon/conf}
IDM_CA_KEYSTORE_TYPE=jks
IDM_CA_KEYSTORE=${CONF_DIR}/idm-cacerts
IDM_CA_KEYSTORE_PWD=${CONF_DIR}/cakeystore.pass

getCaKeystorePwd(){
    if test ! -e ${IDM_CA_KEYSTORE_PWD} ; then
        echo ${JRE_CA_PASS}
    else
        cat ${IDM_CA_KEYSTORE_PWD}
    fi
}

setCaKeystorePwd(){
    local NEW_PWD=$1
    local OLD_PWD=$(getCaKeystorePwd)
    ${JRE_KEYTOOL} -storepasswd -storepass ${OLD_PWD} -new ${NEW_PWD} -keystore ${IDM_CA_KEYSTORE}
    if test $? -eq 0 ; then
        echo -n $NEW_PWD > ${IDM_CA_KEYSTORE_PWD}
        chown ${TOMCAT_USER}:wheel ${IDM_CA_KEYSTORE_PWD}
        chmod 400 ${IDM_CA_KEYSTORE_PWD}
    fi
}

# install the root ca into java and /etc/ssl
install_ca(){
    local CERTFILE=$1
    local ALIAS=$2
    local FILE_ALIAS=$3

    local STOREPASS=`getCaKeystorePwd`
    local KEYSTORE=$IDM_CA_KEYSTORE

    install_ca_helper $CERTFILE $ALIAS $FILE_ALIAS $STOREPASS $KEYSTORE pem true
}

install_ca_helper(){
    local CERTFILE=$1
    local ALIAS=$2
    local FILE_ALIAS=$3
    local STOREPASS=$4
    local KEYSTORE=$5
    local FILE_EXTENSION=$6
    local COPY_CERT=$7

    # have to delete the old entry if it is already there.
    $JRE_KEYTOOL -delete -keystore $KEYSTORE -alias $ALIAS -storepass $STOREPASS > /dev/null 2>&1

    # install it to jdk using keytool
    $JRE_KEYTOOL -import -trustcacerts -noprompt -keystore $KEYSTORE -alias $ALIAS -storepass $STOREPASS -file $CERTFILE

    # it also needs to be here, this is a public directory of known root ca's
    if [ "$COPY_CERT" = "true" ] ; then
        sudo /usr/local/horizon/scripts/publishCaCert.hzn "$CERTFILE" "$FILE_ALIAS.$FILE_EXTENSION"
    fi
    return $?
}

uninstall_ca(){
    local ALIAS=$1
    local FILE_ALIAS=$2
    local STOREPASS=$3
    local KEYSTORE=$4
    local FILE_EXTENSION=$5

    # have to delete the old entry if it is already there.
    $JRE_KEYTOOL -delete -keystore $KEYSTORE -alias $ALIAS -storepass $STOREPASS > /dev/null 2>&1

    # it also needs to be removed from here, this is a public directory of known root ca's
    rm -f /etc/ssl/certs/$FILE_ALIAS.$FILE_EXTENSION
    c_rehash > /dev/null

    return $?
}

bootstrap_cacerts(){
    if [ ! -e ${IDM_CA_KEYSTORE} ]; then
        cp "${JRE_CA_CERTS}" "${IDM_CA_KEYSTORE}"
    fi
    chown ${TOMCAT_USER} "${IDM_CA_KEYSTORE}"
    chmod 644 "${IDM_CA_KEYSTORE}"
}