#!/bin/sh

SUDOERS_FILE=/etc/sudoers
LINE_ID="horizon ALL = NOPASSWD:"

function replaceSudoers(){
    # fix up sudoers, remove our list and replace it
    sed -i -e ':x; /\\$/ { N; s/\\\n//; tx }' -e "/^[[:space:]]*horizon/d" ${SUDOERS_FILE}
    echo "$1" | sed -e "s/_NEWLINE_/\n/g" >> ${SUDOERS_FILE}
}

function getSudoers(){
  #Optionally remove a script from sudoers when called
  local SCRIPT=$1
  #get the current list w/o the requested script
  local SUDOERS=`awk "/${LINE_ID}/,"'/[^\\\\]$/ {print $0 "_NEWLINE_";}' ${SUDOERS_FILE} | sed -r -e "s/${LINE_ID}[[:space:]]*//" -e "s|${SCRIPT}[, \\]*_NEWLINE_|_NEWLINE_|g" -e '/^[[:space:]]*_NEWLINE_$/d' | tr -d '\n' |  sed -e 's/,[[:space:]]*\\\\_NEWLINE_$//' -e 's/_NEWLINE_$//'`

  echo $SUDOERS
}

function addToSudoers(){
    local SCRIPT=$1

    #get the current list w/o the requested script
    local SUDOERS=`getSudoers "${SCRIPT}"`

    if test -z "${SUDOERS}"; then
        SUDOERS="${LINE_ID} ${SCRIPT}"
    else
        SUDOERS="${LINE_ID} ${SUDOERS}, \_NEWLINE_${SCRIPT}"
    fi
    replaceSudoers "${SUDOERS}"
}

function removeFromSudoers(){
    local SCRIPT=$1

    #get the current list w/o the requested script
    local SUDOERS=`getSudoers "${SCRIPT}"`

    replaceSudoers "${LINE_ID} ${SUDOERS}"
}

function replaceSudoParam(){
  KEY=$1
  VAL=$2
  if test -z "$KEY" -o -z "$VAL" ; then
    return
  fi
  sed -i -r -e "$ a\
Defaults $KEY = $VAL" -e "/^[[:space:]]*Defaults[[:space:]]+$KEY[[:space:]]*=/d" $SUDOERS_FILE
}
