
. /usr/local/horizon/scripts/hzn-bin.inc
. /usr/local/horizon/scripts/manageTcCfg.inc
. /usr/local/horizon/scripts/utils.inc
. /usr/local/horizon/scripts/flag.inc

NODE_CACHE=/usr/local/horizon/conf/node.cache

function enumerateitems()
{
    local nodetype=${1-ipaddress}
    local port=$(getHTTPSPort)

    if test $(isAppDeployed SAAS) -eq 1 -a -n "$port" ; then

#prevent the script from running simultaneously
(
      /usr/bin/flock -x -n 200 || exit 1

      # Rate limit the calls to the service to once a minute
      if [[ ! -e "${NODE_CACHE}" || `find "${NODE_CACHE}" -mmin +1` ]] ; then
        # cache is expired, remove it
        rm -f ${NODE_CACHE}

        local QUERY_PARAM=

        if [ -f $FLAG_DATACENTER_ID ] ; then
            QUERY_PARAM="datacenterId=$(<$FLAG_DATACENTER_ID)"
        elif [ ! -f $FLAG_NO_DATACENTER ] ; then
            QUERY_PARAM="currentDatacenter=true"
        else
            QUERY_PARAM="currentDatacenter=false"
        fi

        #timeout in 10 seconds
        local curl_output=$(curl -m 10 -s -k https://localhost:${port}/SAAS/jersey/manager/api/system/clusterInstances?${QUERY_PARAM})
        if [ $? -eq 0 -a -n "$curl_output" ]; then
          echo "$curl_output" | sed -e 's/,/\n/g' | sort | uniq > ${NODE_CACHE}
        fi
      fi
) 200>/tmp/managenodes.lock

      if [ -e ${NODE_CACHE} ] ; then
        awk -F'"' '/"'"$nodetype"'"/ {printf "%s ",$4}' ${NODE_CACHE} | sed -r -e 's/[[:space:]]+$//'
      fi
    elif test "$nodetype" = "ipaddress"; then
      myip
    else
      hostname -f
    fi
}

# enumerate the nodes in a vapp
function enumeratenodeips()
{
    enumerateitems ipaddress
}

# enumerate node DNS names
function enumeratenodenames()
{
    enumerateitems hostname
}
