#!/bin/sh

if [ ! -x "$JAVA_HOME" ] ; then
  JAVA_HOME="/usr/java/jre-vmware"
fi

HZN_TOOL_HOME=/usr/local/horizon

PROVIDER=org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider
KEYTOOL=${JAVA_HOME}/bin/keytool
KEYSTORE=${HZN_TOOL_HOME}/bin/masterkeys.bcfks
RUNTIME_CONFIG=${HZN_TOOL_HOME}/conf/runtime-config.properties
BC_JAR=$(ls -1r ${HZN_TOOL_HOME}/jre-endorsed/bc-fips*jar | head -1 )

#deprecated default password, that should not be in use
DEFAULT_MASTERKEYSTORE_PASS="H0rizon!"

. /usr/local/horizon/scripts/utils.inc

updateMasterKeystorePwdConfig(){
  local PASSWORD=$1

  for KEY in secure.components.encryptionService.db.masterKeyStorePwd secure.components.suiteToken.keyStorePwd ; do
    replaceProperty ${KEY} $(/usr/sbin/hznEncrypt "${PASSWORD}") ${RUNTIME_CONFIG}
  done
}

generateInitialMasterKeystorePwd(){
  if test ! -f ${KEYSTORE} ; then
    updateMasterKeystorePwdConfig "$(randpw)"
  fi
}

isMasterKeystoreDefaultPwd(){
  verifyMasterKeystorePwd ${DEFAULT_MASTERKEYSTORE_PASS};
}

verifyMasterKeystorePwd(){
  local PASSWORD=$1
  ${KEYTOOL} -list -keystore ${KEYSTORE} -provider ${PROVIDER} -storetype BCFKS -providerPath ${BC_JAR} -storepass "${PASSWORD}" > /dev/null 2>&1
}

changeMasterKeystorePwd(){
  local CUR_PASSWD=$1
  local NEW_PASSWD=$2

  if [ -z "$CUR_PASSWD" -o -z "$NEW_PASSWD" ]; then
    echo Failed to specify current and new passwords
    exit 1
  fi

  if [ ${#NEW_PASSWD} -le 6 ]; then
    echo New password must be longer than 6 characters
    exit 2
  fi

  if ! `verifyMasterKeystorePwd "${CUR_PASSWD}"` ; then
    echo Specified current password is invalid.
    exit 3
  fi

  local isRunning=`service horizon-workspace status | grep -c "RUNNING as"`

  if [ $isRunning -gt 0 ]; then
    service horizon-workspace stop
  fi

  ALIASES=$(${KEYTOOL} -list -v -keystore ${KEYSTORE} -provider ${PROVIDER} -storetype BCFKS -providerPath ${BC_JAR} -storepass "${CUR_PASSWD}" | grep "Alias name" | awk -F: '{ print $2}')

  for ALIAS in $ALIASES ; do
    echo changing $ALIAS password
    ${KEYTOOL} -keypasswd  -alias ${ALIAS} -keystore ${KEYSTORE} -provider ${PROVIDER} -storetype BCFKS -providerPath ${BC_JAR} -storepass "${CUR_PASSWD}" -keypass "${CUR_PASSWD}" -new "${NEW_PASSWD}"
  done

  echo updating keystore password
  ${KEYTOOL} -storepasswd -keystore ${KEYSTORE} -provider ${PROVIDER} -storetype BCFKS -providerPath ${BC_JAR} -storepass "${CUR_PASSWD}" -new "${NEW_PASSWD}"

  if test $? -eq 0 ; then
    echo updating configuration
    updateMasterKeystorePwdConfig "${NEW_PASSWD}"
  fi

  if test ${isRunning} -gt 0; then
    service horizon-workspace start
  fi
}


