
# stop security attacks, secure a few values
export PATH="/sbin:/bin:/usr/sbin:/usr/bin:/opt/vmware/bin"
export IFS=$' \t\n'

BLUEBG=`tput setab 4`
BLACKBG=`tput setab 0`
BOLD=`tput bold`
REVERSE=`tput rev`
NORMAL=`tput sgr0; echo -n $BLUEBG`
GREENFG=`tput setaf 2; echo -n $BLUEBG`
REDFG=`tput setaf 1; echo -n $BLUEBG`
WHITEFG=`tput setaf 7; echo -n $BLUEBG`
YELLOWFG=`tput setaf 3; echo -n $BLUEBG`
CLEAR=`echo $BLUEBG; tput clear`

TITLE_ON=${REVERSE}${BOLD}
TITLE_OFF=$NORMAL
HEAD_ON=$REVERSE
HEAD_OFF=$NORMAL
DATA_ON=$BOLD
DATA_OFF=$NORMAL

AUTOMATION_LOG=/opt/vmware/var/log/autoDeploy.log

#
# I can't decide whether or not I prefer bold prompts
#
# PROMPT_ON=${BOLD}
# PROMPT_OFF=${NORMAL}
PROMPT_ON=
PROMPT_OFF=

#
# center text
#
# $1 == string for color on
# $2 == string for color off
# $3 == string to center
#
center()
{
    col_on="$1"
    col_off="$2"
    text="$3"

    halfcols=$((`stty size | cut -f2 -d' '` / 2))

    nchars=${#text}
    nspaces=$(($halfcols - $nchars / 2))
    while [ $nspaces -gt 0 ]
    do
        echo -e " "\\c
        nspaces=$(($nspaces - 1))
    done
    echo ${col_on}${text}${col_off}
}

center_data()
{
    center ${DATA_ON} ${DATA_OFF} "$*"
}

#
# print a title
#
title()
{
    center ${TITLE_ON} ${TITLE_OFF} "$*"
}

#
# reset the colors
#
reset_colors()
{
    echo ${NORMAL}
}

#
# read_or_quit
#
# Reads a string, and if a sole q is seen, quit the program
# pass -s to read silently like a password
# pass in a default value (not -s) to default if the user presses enter
#
read_or_quit()
{
    pass=
    if [ "x$1" = "x-s" ]
    then
    	pass="-s"
	shift
    fi
    read $pass a
    if [ "$a" = "q" ]
    then
        kill $$
    fi
    if [ "x$a" = "x" ]
    then
        a=$1
    fi
    echo "$a"   
}

# put up a three line banner with centered header text.
banner()
{
    text=$1

    width=$((`stty size | cut -f2 -d' '` ))
    echo -n $REVERSE

    cols=$(($width * 2))
    while [ $cols -gt 0 ]
    do
        echo -e " "\\c
        cols=$(($cols - 1))
    done

    halfcols=$((width / 2))
    nchars=${#text}
    nspaces=$(($halfcols - $nchars / 2))
    leftspaces=$(( $width - ($nchars + $nspaces ) ))

    while [ $nspaces -gt 0 ]
    do
        echo -e " "\\c
        nspaces=$(($nspaces - 1))
    done
    echo -n ${text}

    while [ $leftspaces -gt 0 ]
    do
        echo -e " "\\c
        leftspaces=$(($leftspaces - 1))
    done

    cols=$width
    while [ $cols -gt 0 ]
    do
        echo -e " "\\c
        cols=$(($cols - 1))
    done
    echo -n $NORMAL
}

# log alert/crit/debug/emerg/err/info/notice/panic/warning "message"
log()
{
    level=$1 ; shift
    logger -p local0.$level $*
}

#
# return a prompted string from the user
#
# $1 == prompt
# $2 == default value
#
get_string()
{
    PROMPT=$1
    DEF=$2

    stderr ${PROMPT_ON}${PROMPT} [$DEF]:${PROMPT_OFF} ${DATA_ON}\\c
    response=`read_or_quit`; stderr ${DATA_OFF}\\c

    if [ "$response" = "" ]
    then
        response=$DEF
    fi

    echo $response
}

#
# return a yes or no from a prompted question
#
# $1 == prompt
# $2 == default value
#
get_yn()
{
    PROMPT=$1
    DEF=$2

    stderr ${HEAD_ON}${PROMPT} y/n [$DEF]:${HEAD_OFF} ${DATA_ON}\\c
    response=`read_or_quit`; stderr ${DATA_OFF}\\c

    if [ "$response" = "" ]
    then
        response=$DEF
    fi

    echo $response
}

#
# print a non-colored line with a description: followed by data
#
# $1 == description
# $2 == data
#
print_plain_data()
{
    echo -e ${1}:\\t${2}
}

#
# print a non-colored line of data
#
# $1 == data
#
print_plain()
{
    echo -e ${1}
}

# this is not a generic json parser
# only very simple formats will work here
get_simple_json_value()
{
    FILE=$1
    NAME=$2

    SCRIPT='/{/,/}/ { if ($1 == "\"XXX\"") { $1=$2=""; print $0;}}'
    SCRIPT=`echo $SCRIPT | sed -e "s/XXX/$NAME/"`
    awk "$SCRIPT" $FILE | sed -r -e 's/^  //' -e 's/,$//' -e 's/"//g'
}
