#!/bin/bash
#
# Copyright 2016 VMware, Inc. All rights reserved.
#
# This script is used to start/stop/restart/status processes
# in postgres services.

. /usr/local/horizon/scripts/distroSpecific.inc


function usage() {
    echo "starts / stops / restarts /status /enableService /disableService process of a postgres service"
    echo "Usage: $0 <command>"
    echo "     command: start | stop | restart | status | enableService | disableService"
    echo "     --help displays this message"
    echo
    exit 1
}

COMMAND_ACTION="$1"

case $COMMAND_ACTION in
    start|stop|restart|status)
        service vpostgres $COMMAND_ACTION
        ;;
    enableService)
        enableService vpostgres
        ;;
    disableService)
        disableService vpostgres
        ;;
    --help)
        usage
        ;;
    *)
        echo "Invalid command"
        usage
        ;;
esac
