#!/bin/bash

HZN_CURL="/usr/local/horizon/bin/curl"

login()
{

local ADMIN_ACCOUNT=$1
local ADMIN_PASSWORD=$2

  echo -e "###### login administrator user \n"
  echo {\"username\":\"$ADMIN_ACCOUNT\", \"password\":\"$ADMIN_PASSWORD\", \"issueToken\":\"true\"} > login.json

AUTH_COOKIE=`$HZN_CURL -k -s -X POST -H "Accept: application/json" -H "Content-Type: application/json" -d@login.json https://$HOST/SAAS/t/$TENANT/API/1.0/REST/auth/system/login | cut -f 3 -d : | sed -e "s/\"//g" -e "s/,.*//"`
  if [ "x$AUTH_COOKIE" = "x" ]
  then
      echo -e "Could not fetch the auth cookie, make sure you entered correct password\n"
      exit 1
  fi
  rm login.json
  echo -e " AUTH COOKIE : $AUTH_COOKIE\n"
  echo -e "SUCCESS\n"

}

createServiceOAuth2Client()
{
echo -e "###### create Service OAuth2Client \n"
$HZN_CURL -k -s -XPOST -H "Authorization: HZN $AUTH_COOKIE" -H "Accept: application/vnd.vmware.horizon.manager.oauth2client+json" -H "Content-Type: application/vnd.vmware.horizon.manager.oauth2client+json" -H "Connection: keep-alive" -d "{

   \"clientId\": \"migration-client\",
   \"secret\": \"Welcome@123\",
   \"scope\": \"admin\",
   \"authGrantTypes\": \"client_credentials\",
   \"accessTokenTTL\": 180000,
   \"inheritanceAllowed\": false

}" "https://$HOST/SAAS/t/$TENANT/jersey/manager/api/oauth2clients"

echo -e "\nSUCCESS\n"
}


getAccessTokenWithHost()
{
echo -e "\n###### Get Access Token"
BASE64_CREDENTIALS=`echo -n  migration-client:Welcome@123 | base64`

echo "$BASE64_CREDENTIALS"

ACCESS_TOKEN=`$HZN_CURL -k -s -XPOST -H "Accept: application/json" -H "Content-Type: application/json" -H "Authorization: Basic $BASE64_CREDENTIALS" "https://$HOST/SAAS/t/$TENANT/auth/oauthtoken?grant_type=client_credentials" | cut -f 2 -d : | sed -e "s/\"//g" -e "s/,.*//"`

echo $ACCESS_TOKEN
}


getAccessToken()
{
getAccessTokenWithHost
if [[ $ACCESS_TOKEN == *"invalid_client"* ]] || [ "x$ACCESS_TOKEN" = "x" ]
then
      echo -e "Creating service Oauth2Client and then Fetch Access Token... \n"

      read -p "Please enter the Tenant Administrator UserName for the tenant $TENANT : " ADMIN_ACCOUNT

      read -p "Please enter the Tenant Administrator Password for the tenant $TENANT : " ADMIN_PASSWORD

      login $ADMIN_ACCOUNT $ADMIN_PASSWORD
      createServiceOAuth2Client
      getAccessTokenWithHost
fi
echo -e "SUCCESS\n"
}

