#!/bin/bash

. /usr/local/horizon/scripts/tenantInHostTokenUtil.sh

usage()
{
    echo "usage: $0 [-m DefaultTenant FQDN] [-u AdminUser Name] [-p AdminUser Password] [-c child Tenant FQDN] [-un User Name] [-up User Password]"
    echo "  -m DefaultTenant FQDN          FQDN of the Default Tenant"
    echo "  -u AdminUser Name              Application Admin Username"
    echo "  -p AdminUser Password          Password of the Admin User"
    echo "  -c child Tenant FQDN           FQDN of the Tenant the User belongs"
    echo "  -un User Name                  Username of the Local User whose password needs to reset"
    echo "  -up User Password              Password to set for the Local User"
    exit 1
}

while getopts ":m:u:p:c:-un:-up:" o; do
    case "${o}" in
         m)
            HOST=${OPTARG}
            ;;
        u)
            ADMIN_ACCOUNT=${OPTARG}
            ;;
        p)
            ADMIN_PASSWORD=${OPTARG}
            ;;
        c)
            TENANT_HOST=${OPTARG}
            ;;
        un)
            USER=${OPTARG}
            ;;
        up)
            PASSWORD=${OPTARG}
            ;;
        *|h)
            usage
            ;;
    esac
done

if [ -z "${HOST}" ] || [ -z "${ADMIN_ACCOUNT}" ] || [ -z "${ADMIN_PASSWORD}" ] || [ -z "${TENANT_HOST}" ] || [ -z "${USER}" ] || [ -z "${PASSWORD}" ]; then
usage
fi

HZN_CURL="/usr/local/horizon/bin/curl"

updatePassword()
{
echo -e "\n###### Update Password \n"
echo { \"attributes\" : \"id\",\"filter\" : \"userName eq \\\"$USER\\\" and internalUserType eq \\\"LOCAL\\\"\"} > user.json
$HZN_CURL -k -s -X POST -H "Authorization: Bearer $ACCESS_TOKEN" -H "Accept: application/json" -H "Content-Type: application/json" -d@user.json  https://$TENANT_HOST/SAAS/jersey/manager/api/scim/Users/.search/ > "id.json"

DATA_FILE="id.json"
UUID=`cat $DATA_FILE | /usr/bin/python -c 'import sys, json,os;
myobj = json.load(sys.stdin);
resources = myobj["Resources"]
for item  in resources:
    print item["id"];'`

echo "User UUID : $UUID"
rm -f user.json
rm -f id.json


echo {\"password\": \"$PASSWORD\" } > password.json
$HZN_CURL -k -s -X PATCH -H "Authorization: Bearer $ACCESS_TOKEN" -H "Accept: application/json" -H "Content-Type: application/json" -d@password.json  https://$TENANT_HOST/SAAS/jersey/manager/api/scim/Users/$UUID
rm -f password.json
echo -e "SUCCESS\n"
}

getAccessToken
updatePassword
