#!/bin/sh

SED_FLAG=-r
echo foo | sed ${SED_FLAG} "s/foo/bar/" > /dev/null 2>&1
if test $? -ne 0 ; then
    SED_FLAG=-E
fi

replaceProperty(){
  local KEY=$1
  local VAL=$2
  local FILE=$3
  local SEP=${4:-=}
  if test -z "$KEY" -o -z "$VAL" ; then
    return
  fi
  sed -i.bk ${SED_FLAG} -e "$ a\
${KEY}${SEP}${VAL}" -e "/^[[:space:]]*$KEY[[:space:]]*${SEP}/d" ${FILE}
}

removeProperty(){
  local KEY=$1
  local FILE=$2
  if test -z "$KEY" -o ! -f ${FILE}; then
    return
  fi
  sed -i.bk ${SED_FLAG} -e "/^[[:space:]]*$KEY[[:space:]]*=.*\\\\/,/[^\\\\]$/d" -e "/^[[:space:]]*$KEY[[:space:]]*=/d" ${FILE}
}

replacePropertyWithContinuation(){
  local KEY=$1
  local VAL=$2
  local FILE=$3
  if test -z "$KEY" -o -z "$VAL" -o ! -f ${FILE} ; then
    return
  fi
  sed -i.bk ${SED_FLAG} -e '$ a\
'"${KEY}=${VAL}" -e "/^[[:space:]]*$KEY[[:space:]]*=.*\\\\/,/[^\\\\]$/d" -e "/^[[:space:]]*$KEY[[:space:]]*=/d" ${FILE}
}

getPropertyVal(){
  local KEY=$1
  local FILE=$2
  local SEP=${3:-=}
  if test -f $FILE; then
    grep -E "^[[:space:]]*${KEY}[[:space:]]*${SEP}" ${FILE} | sed ${SED_FLAG} -e "s/^[^${SEP}]+${SEP}//"
  fi
}

addPropertyIfNotDefined(){
  local KEY=$1
  local VAL=$2
  local FILE=$3

  if test -z "$(getPropertyVal ${KEY} ${FILE})"; then
    replaceProperty ${KEY} ${VAL} ${FILE}
  fi
}

randpw(){ LC_CTYPE=C < /dev/urandom tr -dc _A-Z-a-z-0-9 | head -c${1:-32};echo;}

escape() {
 echo "$1" | sed ${SED_FLAG} -e 's/([^a-zA-Z0-9])/\\\1/g'
}

myip(){
    /sbin/ifconfig | grep "inet addr" | grep -v "127.0.0.1" | awk '{ print $2 }' | awk -F: '{ print $2; exit }'
}

toLowerCase(){
    echo "$1" | tr '[:upper:]' '[:lower:]'
}

toUpperCase(){
    echo "$1" | tr '[:lower:]' '[:upper:]'
}
