#!/bin/sh

# Script to find issues in vRA 7.x cluster


CATALINA_PROP=/opt/vmware/horizon/workspace/conf/catalina.properties
STORE=/opt/vmware/horizon/workspace/conf/tcserver.keystore
JAR=`find /usr -iname "*bc-fips*.jar" | grep jre`
RABBIT_MQ_CONF=/etc/rabbitmq/rabbitmq-env.conf
# color map
ERROR='\e[01;31m'
NC='\e[0m' # No Color

echo '******************'
echo
echo This is a diagnostic script to be used for vRA 7.5 and vRA 7.6
echo Please run this script on all the nodes and compare the results
echo

VSP_COUNT=`grep -i -r "masterTenant" /usr/local/horizon/conf/states/*/*/config-state* | grep true | cut -f 7 -d / | wc -l`
echo Checking the masterTenant flag in /usr/local/horizon/conf/states/ folder
if [ "$VSP_COUNT" -eq 1 ]
then
   VSP=`grep -i -r "masterTenant" /usr/local/horizon/conf/states/*/*/config-state* | grep true | cut -f 7 -d /`
   if [ "x$VSP" == "xVSPHERE.LOCAL" ]
   then
      echo '******************'
      echo
      echo masterTenant flag is enabled only on $VSP which is correct.
      echo
   else
      echo '******************'
      echo
      echo -e ${ERROR} masterTenant flag is not enabled on default VSPHERE.LOCAL tenant
      echo
   fi
else
   echo '******************'
   echo -e "${ERROR}masterTenant flag is enabled in $VSP_COUNT files, which is not correct. ${NC}"
   echo
   echo Please fix
   grep -i -r "masterTenant.*true.*" /usr/local/horizon/conf/states/*/*/config-state*
   echo to disable the flag.
   echo
fi

BCFKS=`grep "nio-ssl.ssl.keystore.type" $CATALINA_PROP | cut -f 2 -d "="`
echo Checking the nio-ssl.ssl.keystore.type in $CATALINA_PROP
if [ "x$BCFKS" = "x" ]
then
   echo '******************'
   echo
   echo -e "${ERROR} Missing property nio-ssl.ssl.keystore.type in $CATALINA_PROP ${NC}"
   echo
fi

PROV=`grep "nio-ssl.ssl.keystore.provider" $CATALINA_PROP`
echo Checking the nio-ssl.ssl.keystore.provider in $CATALINA_PROP
if [[ ( "x$PROV" = "x" ) || ( "x$PROV" = "xSUN" ) ]]
then
   echo '******************'
   echo
   BCFKS=`grep "nio-ssl.ssl.keystore.type" $CATALINA_PROP | cut -f 2 -d "="`
   if [ "x$BCFKS" = "xJKS" ]
   then
       echo -e "${ERROR} Missing property nio-ssl.ssl.keystore.provider in $CATALINA_PROP ${NC}"
       echo Should that be SUN?
       echo After join cluster make sure to run the following:
       echo disable FIPS mode in vIDM -
       echo mkdir /root/tmp-bkp
       echo mv /usr/local/horizon/conf/flags/fips* /root/tmp-bkp
       echo recreate the vIDM certificate:
       echo mv /opt/vmware/horizon/workspace/conf/tcserver.keystore /opt/vmware/horizon/workspace/conf/tcserver.keystore.backup
       echo /usr/local/horizon/scripts/secure/wizardssl.hzn
       echo /etc/init.d/horizon-workspace restart
   else
      echo -e "${ERROR} Missing property nio-ssl.ssl.keystore.provider in $CATALINA_PROP ${NC}"
   fi
   echo
else
   echo '******************'
   echo
   echo Found nio-ssl.ssl.keystore.provider in $CATALINA_PROP
   grep nio-ssl.ssl.keystore.provider $CATALINA_PROP
   echo
fi

grep "passthrough" $CATALINA_PROP > /dev/null
echo Checking the passthrough properties in $CATALINA_PROP
if [ $? -ne 0 ]
then
    echo '******************'
    echo
    echo -e "${ERROR} Missing property 'ssl.passthrough.alias=passthrough' $CATALINA_PROP ${NC}"
    echo -e "${ERROR} Missing property 'https.passthrough.port=7443' $CATALINA_PROP ${NC}"
    echo
else
    echo '******************'
    echo
    echo Found passthrough entries in $CATALINA_PROP
    grep "passthrough" $CATALINA_PROP
    echo Note: The passthrough port is recommended to be 7443
    echo
fi

grep "http.port" $CATALINA_PROP > /dev/null
echo Checking http.port in $CATALINA_PROP
if [ $? -ne 0 ]
then
    echo '******************'
    echo
    echo -e "${ERROR} Missing property 'http.port=8080' $CATALINA_PROP ${NC}"
    echo
else
    echo '******************'
    echo
    echo Found http.port entries in $CATALINA_PROP
    grep "http.port" $CATALINA_PROP
    echo Note: The above port is recommended to be 8080
    echo
fi

STOREPASS=`grep ssl.keystore.password $CATALINA_PROP | cut -f 2 -d "="`
echo Checking ssl.keystore.password in $CATALINA_PROP
/usr/java/jre-vmware/bin/keytool -v -list -keystore $STORE -storetype $BCFKS -provider org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider -providerpath $JAR -storepass $STOREPASS > /dev/null

if [ $? -eq 0 ]
then
   echo '******************'
   echo
   echo $STORE is a $BCFKS keystore
   echo
else
   echo '******************'
   echo
   echo $STORE is not a BCFKS keystore
   echo
fi

USER=`stat -c "%U" $STORE`
echo Checking permissions and ownership of $STORE
if [ $USER != "horizon" ]
then
    echo '******************'
    echo
    echo -e "${ERROR} File $STORE is not owned by horizon ${NC}"
    echo Please run chown horizon:www $STORE
    echo
else
    echo '******************'
    echo
    echo File $STORE has right "horizon" user permission
    echo
fi

GROUP=`stat -c "%G" $STORE`
if [ $GROUP != "www" ]
then
    echo '******************'
    echo
    echo -e "${ERROR} File $STORE is not owned by www ${NC}"
    echo Please run chown horizon:www $STORE
    echo
else
    echo '******************'
    echo
    echo File $STORE has right "www" group permission
    echo
fi

PERM=`stat -c "%a" $STORE`
if [ $PERM -eq 644 ]
then
    echo '******************'
    echo
    echo File $STORE has the right $PERM
    echo
else
    echo '******************'
    echo
    echo -e "${ERROR} File $STORE does not have 644 perms ${NC}"
    echo Please run chmod 644 $STORE
    echo -en "${NC}"
fi

LONGNAME=`grep USE_LONGNAME $RABBIT_MQ_CONF | cut -f 2 -d "="`
echo checking USE_LONGNAME in $RABBIT_MQ_CONF
if [ $LONGNAME == true ]
then
    echo '******************'
    echo
    echo USE_LONGNAME is not recommended in $RABBIT_MQ_CONF
    echo
else
    echo '******************'
    echo
    echo USE_LONGNAME is not configured on this node check $RABBIT_MQ_CONF
    echo
fi

rabbitmqctl cluster_status | grep -A 1 running_nodes | grep "\."
if [ $? -ne 0 ]
then
    echo '******************'
    echo
    echo USE_LONGNAME is not configured on other nodes.
    echo Please check
    rabbitmqctl cluster_status | grep -A 1 running_nodes
    echo
else
    echo '******************'
    echo
    echo -e "${ERROR} Seems like USE_LONGNAME is configured on other nodes.${NC}"
    echo check using 'rabbitmqctl cluster_status | grep -A 1 running_nodes'
    echo
fi

echo '******************'
echo
echo Running the script: check-stale-connectors.sh -c
echo To find out if there are any stale connectors
echo
sh check-stale-connectors.sh -c
