require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_KVM_H)) {
    eval 'sub __LINUX_KVM_H () {1;}' unless defined(&__LINUX_KVM_H);
    require 'linux/types.ph';
    require 'linux/ioctl.ph';
    require 'asm/kvm.ph';
    eval 'sub KVM_API_VERSION () {12;}' unless defined(&KVM_API_VERSION);
    eval 'sub KVM_MEM_LOG_DIRTY_PAGES () {1;}' unless defined(&KVM_MEM_LOG_DIRTY_PAGES);
    eval 'sub KVM_MEMSLOT_INVALID () {(1 << 1);}' unless defined(&KVM_MEMSLOT_INVALID);
    if(defined(&__KVM_HAVE_PIT)) {
    }
    if(defined(&__KVM_HAVE_IOAPIC)) {
    }
    eval 'sub KVM_PIT_SPEAKER_DUMMY () {1;}' unless defined(&KVM_PIT_SPEAKER_DUMMY);
    eval 'sub KVM_EXIT_UNKNOWN () {0;}' unless defined(&KVM_EXIT_UNKNOWN);
    eval 'sub KVM_EXIT_EXCEPTION () {1;}' unless defined(&KVM_EXIT_EXCEPTION);
    eval 'sub KVM_EXIT_IO () {2;}' unless defined(&KVM_EXIT_IO);
    eval 'sub KVM_EXIT_HYPERCALL () {3;}' unless defined(&KVM_EXIT_HYPERCALL);
    eval 'sub KVM_EXIT_DEBUG () {4;}' unless defined(&KVM_EXIT_DEBUG);
    eval 'sub KVM_EXIT_HLT () {5;}' unless defined(&KVM_EXIT_HLT);
    eval 'sub KVM_EXIT_MMIO () {6;}' unless defined(&KVM_EXIT_MMIO);
    eval 'sub KVM_EXIT_IRQ_WINDOW_OPEN () {7;}' unless defined(&KVM_EXIT_IRQ_WINDOW_OPEN);
    eval 'sub KVM_EXIT_SHUTDOWN () {8;}' unless defined(&KVM_EXIT_SHUTDOWN);
    eval 'sub KVM_EXIT_FAIL_ENTRY () {9;}' unless defined(&KVM_EXIT_FAIL_ENTRY);
    eval 'sub KVM_EXIT_INTR () {10;}' unless defined(&KVM_EXIT_INTR);
    eval 'sub KVM_EXIT_SET_TPR () {11;}' unless defined(&KVM_EXIT_SET_TPR);
    eval 'sub KVM_EXIT_TPR_ACCESS () {12;}' unless defined(&KVM_EXIT_TPR_ACCESS);
    eval 'sub KVM_EXIT_S390_SIEIC () {13;}' unless defined(&KVM_EXIT_S390_SIEIC);
    eval 'sub KVM_EXIT_S390_RESET () {14;}' unless defined(&KVM_EXIT_S390_RESET);
    eval 'sub KVM_EXIT_DCR () {15;}' unless defined(&KVM_EXIT_DCR);
    eval 'sub KVM_EXIT_NMI () {16;}' unless defined(&KVM_EXIT_NMI);
    eval 'sub KVM_EXIT_INTERNAL_ERROR () {17;}' unless defined(&KVM_EXIT_INTERNAL_ERROR);
    eval 'sub KVM_INTERNAL_ERROR_EMULATION () {1;}' unless defined(&KVM_INTERNAL_ERROR_EMULATION);
    if(defined(&__KVM_S390)) {
    }
    eval 'sub KVM_EXIT_IO_IN () {0;}' unless defined(&KVM_EXIT_IO_IN);
    eval 'sub KVM_EXIT_IO_OUT () {1;}' unless defined(&KVM_EXIT_IO_OUT);
    eval 'sub KVM_S390_RESET_POR () {1;}' unless defined(&KVM_S390_RESET_POR);
    eval 'sub KVM_S390_RESET_CLEAR () {2;}' unless defined(&KVM_S390_RESET_CLEAR);
    eval 'sub KVM_S390_RESET_SUBSYSTEM () {4;}' unless defined(&KVM_S390_RESET_SUBSYSTEM);
    eval 'sub KVM_S390_RESET_CPU_INIT () {8;}' unless defined(&KVM_S390_RESET_CPU_INIT);
    eval 'sub KVM_S390_RESET_IPL () {16;}' unless defined(&KVM_S390_RESET_IPL);
    eval 'sub KVM_COALESCED_MMIO_MAX () {(( &PAGE_SIZE - $sizeof{\'struct kvm_coalesced_mmio_ring\'}) / $sizeof{\'struct kvm_coalesced_mmio\'});}' unless defined(&KVM_COALESCED_MMIO_MAX);
    eval 'sub KVM_MP_STATE_RUNNABLE () {0;}' unless defined(&KVM_MP_STATE_RUNNABLE);
    eval 'sub KVM_MP_STATE_UNINITIALIZED () {1;}' unless defined(&KVM_MP_STATE_UNINITIALIZED);
    eval 'sub KVM_MP_STATE_INIT_RECEIVED () {2;}' unless defined(&KVM_MP_STATE_INIT_RECEIVED);
    eval 'sub KVM_MP_STATE_HALTED () {3;}' unless defined(&KVM_MP_STATE_HALTED);
    eval 'sub KVM_MP_STATE_SIPI_RECEIVED () {4;}' unless defined(&KVM_MP_STATE_SIPI_RECEIVED);
    eval 'sub KVM_S390_SIGP_STOP () {0xfffe0000;}' unless defined(&KVM_S390_SIGP_STOP);
    eval 'sub KVM_S390_PROGRAM_INT () {0xfffe0001;}' unless defined(&KVM_S390_PROGRAM_INT);
    eval 'sub KVM_S390_SIGP_SET_PREFIX () {0xfffe0002;}' unless defined(&KVM_S390_SIGP_SET_PREFIX);
    eval 'sub KVM_S390_RESTART () {0xfffe0003;}' unless defined(&KVM_S390_RESTART);
    eval 'sub KVM_S390_INT_VIRTIO () {0xffff2603;}' unless defined(&KVM_S390_INT_VIRTIO);
    eval 'sub KVM_S390_INT_SERVICE () {0xffff2401;}' unless defined(&KVM_S390_INT_SERVICE);
    eval 'sub KVM_S390_INT_EMERGENCY () {0xffff1201;}' unless defined(&KVM_S390_INT_EMERGENCY);
    eval 'sub KVM_GUESTDBG_ENABLE () {0x1;}' unless defined(&KVM_GUESTDBG_ENABLE);
    eval 'sub KVM_GUESTDBG_SINGLESTEP () {0x2;}' unless defined(&KVM_GUESTDBG_SINGLESTEP);
    eval("sub kvm_ioeventfd_flag_nr_datamatch () { 0; }") unless defined(&kvm_ioeventfd_flag_nr_datamatch);
    eval("sub kvm_ioeventfd_flag_nr_pio () { 1; }") unless defined(&kvm_ioeventfd_flag_nr_pio);
    eval("sub kvm_ioeventfd_flag_nr_deassign () { 2; }") unless defined(&kvm_ioeventfd_flag_nr_deassign);
    eval("sub kvm_ioeventfd_flag_nr_max () { 3; }") unless defined(&kvm_ioeventfd_flag_nr_max);
    eval 'sub KVM_IOEVENTFD_FLAG_DATAMATCH () {(1<<  &kvm_ioeventfd_flag_nr_datamatch);}' unless defined(&KVM_IOEVENTFD_FLAG_DATAMATCH);
    eval 'sub KVM_IOEVENTFD_FLAG_PIO () {(1<<  &kvm_ioeventfd_flag_nr_pio);}' unless defined(&KVM_IOEVENTFD_FLAG_PIO);
    eval 'sub KVM_IOEVENTFD_FLAG_DEASSIGN () {(1<<  &kvm_ioeventfd_flag_nr_deassign);}' unless defined(&KVM_IOEVENTFD_FLAG_DEASSIGN);
    eval 'sub KVM_IOEVENTFD_VALID_FLAG_MASK () {((1<<  &kvm_ioeventfd_flag_nr_max) - 1);}' unless defined(&KVM_IOEVENTFD_VALID_FLAG_MASK);
    eval 'sub KVM_TRC_SHIFT () {16;}' unless defined(&KVM_TRC_SHIFT);
    eval 'sub KVM_TRC_ENTRYEXIT () {(1<<  &KVM_TRC_SHIFT);}' unless defined(&KVM_TRC_ENTRYEXIT);
    eval 'sub KVM_TRC_HANDLER () {(1<< ( &KVM_TRC_SHIFT + 1));}' unless defined(&KVM_TRC_HANDLER);
    eval 'sub KVM_TRC_VMENTRY () {( &KVM_TRC_ENTRYEXIT + 0x1);}' unless defined(&KVM_TRC_VMENTRY);
    eval 'sub KVM_TRC_VMEXIT () {( &KVM_TRC_ENTRYEXIT + 0x2);}' unless defined(&KVM_TRC_VMEXIT);
    eval 'sub KVM_TRC_PAGE_FAULT () {( &KVM_TRC_HANDLER + 0x1);}' unless defined(&KVM_TRC_PAGE_FAULT);
    eval 'sub KVM_TRC_HEAD_SIZE () {12;}' unless defined(&KVM_TRC_HEAD_SIZE);
    eval 'sub KVM_TRC_CYCLE_SIZE () {8;}' unless defined(&KVM_TRC_CYCLE_SIZE);
    eval 'sub KVM_TRC_EXTRA_MAX () {7;}' unless defined(&KVM_TRC_EXTRA_MAX);
    eval 'sub KVMIO () {0xae;}' unless defined(&KVMIO);
    eval 'sub KVM_GET_API_VERSION () { &_IO( &KVMIO, 0x);}' unless defined(&KVM_GET_API_VERSION);
    eval 'sub KVM_CREATE_VM () { &_IO( &KVMIO, 0x1);}' unless defined(&KVM_CREATE_VM);
    eval 'sub KVM_GET_MSR_INDEX_LIST () { &_IOWR( &KVMIO, 0x2, \'struct kvm_msr_list\');}' unless defined(&KVM_GET_MSR_INDEX_LIST);
    eval 'sub KVM_S390_ENABLE_SIE () { &_IO( &KVMIO, 0x6);}' unless defined(&KVM_S390_ENABLE_SIE);
    eval 'sub KVM_CHECK_EXTENSION () { &_IO( &KVMIO, 0x3);}' unless defined(&KVM_CHECK_EXTENSION);
    eval 'sub KVM_GET_VCPU_MMAP_SIZE () { &_IO( &KVMIO, 0x4);}' unless defined(&KVM_GET_VCPU_MMAP_SIZE);
    eval 'sub KVM_GET_SUPPORTED_CPUID () { &_IOWR( &KVMIO, 0x5, \'struct kvm_cpuid2\');}' unless defined(&KVM_GET_SUPPORTED_CPUID);
    eval 'sub KVM_TRACE_ENABLE () { &_IOW( &KVMIO, 0x6, \'struct kvm_user_trace_setup\');}' unless defined(&KVM_TRACE_ENABLE);
    eval 'sub KVM_TRACE_PAUSE () { &_IO( &KVMIO, 0x7);}' unless defined(&KVM_TRACE_PAUSE);
    eval 'sub KVM_TRACE_DISABLE () { &_IO( &KVMIO, 0x8);}' unless defined(&KVM_TRACE_DISABLE);
    eval 'sub KVM_CAP_IRQCHIP () {0;}' unless defined(&KVM_CAP_IRQCHIP);
    eval 'sub KVM_CAP_HLT () {1;}' unless defined(&KVM_CAP_HLT);
    eval 'sub KVM_CAP_MMU_SHADOW_CACHE_CONTROL () {2;}' unless defined(&KVM_CAP_MMU_SHADOW_CACHE_CONTROL);
    eval 'sub KVM_CAP_USER_MEMORY () {3;}' unless defined(&KVM_CAP_USER_MEMORY);
    eval 'sub KVM_CAP_SET_TSS_ADDR () {4;}' unless defined(&KVM_CAP_SET_TSS_ADDR);
    eval 'sub KVM_CAP_VAPIC () {6;}' unless defined(&KVM_CAP_VAPIC);
    eval 'sub KVM_CAP_EXT_CPUID () {7;}' unless defined(&KVM_CAP_EXT_CPUID);
    eval 'sub KVM_CAP_CLOCKSOURCE () {8;}' unless defined(&KVM_CAP_CLOCKSOURCE);
    eval 'sub KVM_CAP_NR_VCPUS () {9;}' unless defined(&KVM_CAP_NR_VCPUS);
    eval 'sub KVM_CAP_NR_MEMSLOTS () {10;}' unless defined(&KVM_CAP_NR_MEMSLOTS);
    eval 'sub KVM_CAP_PIT () {11;}' unless defined(&KVM_CAP_PIT);
    eval 'sub KVM_CAP_NOP_IO_DELAY () {12;}' unless defined(&KVM_CAP_NOP_IO_DELAY);
    eval 'sub KVM_CAP_PV_MMU () {13;}' unless defined(&KVM_CAP_PV_MMU);
    eval 'sub KVM_CAP_MP_STATE () {14;}' unless defined(&KVM_CAP_MP_STATE);
    eval 'sub KVM_CAP_COALESCED_MMIO () {15;}' unless defined(&KVM_CAP_COALESCED_MMIO);
    eval 'sub KVM_CAP_SYNC_MMU () {16;}' unless defined(&KVM_CAP_SYNC_MMU);
    if(defined(&__KVM_HAVE_DEVICE_ASSIGNMENT)) {
	eval 'sub KVM_CAP_DEVICE_ASSIGNMENT () {17;}' unless defined(&KVM_CAP_DEVICE_ASSIGNMENT);
    }
    eval 'sub KVM_CAP_IOMMU () {18;}' unless defined(&KVM_CAP_IOMMU);
    if(defined(&__KVM_HAVE_MSI)) {
	eval 'sub KVM_CAP_DEVICE_MSI () {20;}' unless defined(&KVM_CAP_DEVICE_MSI);
    }
    eval 'sub KVM_CAP_DESTROY_MEMORY_REGION_WORKS () {21;}' unless defined(&KVM_CAP_DESTROY_MEMORY_REGION_WORKS);
    if(defined(&__KVM_HAVE_USER_NMI)) {
	eval 'sub KVM_CAP_USER_NMI () {22;}' unless defined(&KVM_CAP_USER_NMI);
    }
    if(defined(&__KVM_HAVE_GUEST_DEBUG)) {
	eval 'sub KVM_CAP_SET_GUEST_DEBUG () {23;}' unless defined(&KVM_CAP_SET_GUEST_DEBUG);
    }
    if(defined(&__KVM_HAVE_PIT)) {
	eval 'sub KVM_CAP_REINJECT_CONTROL () {24;}' unless defined(&KVM_CAP_REINJECT_CONTROL);
    }
    if(defined(&__KVM_HAVE_IOAPIC)) {
	eval 'sub KVM_CAP_IRQ_ROUTING () {25;}' unless defined(&KVM_CAP_IRQ_ROUTING);
    }
    eval 'sub KVM_CAP_IRQ_INJECT_STATUS () {26;}' unless defined(&KVM_CAP_IRQ_INJECT_STATUS);
    if(defined(&__KVM_HAVE_DEVICE_ASSIGNMENT)) {
	eval 'sub KVM_CAP_DEVICE_DEASSIGNMENT () {27;}' unless defined(&KVM_CAP_DEVICE_DEASSIGNMENT);
    }
    if(defined(&__KVM_HAVE_MSIX)) {
	eval 'sub KVM_CAP_DEVICE_MSIX () {28;}' unless defined(&KVM_CAP_DEVICE_MSIX);
    }
    eval 'sub KVM_CAP_ASSIGN_DEV_IRQ () {29;}' unless defined(&KVM_CAP_ASSIGN_DEV_IRQ);
    eval 'sub KVM_CAP_JOIN_MEMORY_REGIONS_WORKS () {30;}' unless defined(&KVM_CAP_JOIN_MEMORY_REGIONS_WORKS);
    if(defined(&__KVM_HAVE_MCE)) {
	eval 'sub KVM_CAP_MCE () {31;}' unless defined(&KVM_CAP_MCE);
    }
    eval 'sub KVM_CAP_IRQFD () {32;}' unless defined(&KVM_CAP_IRQFD);
    if(defined(&__KVM_HAVE_PIT)) {
	eval 'sub KVM_CAP_PIT2 () {33;}' unless defined(&KVM_CAP_PIT2);
    }
    eval 'sub KVM_CAP_SET_BOOT_CPU_ID () {34;}' unless defined(&KVM_CAP_SET_BOOT_CPU_ID);
    if(defined(&__KVM_HAVE_PIT_STATE2)) {
	eval 'sub KVM_CAP_PIT_STATE2 () {35;}' unless defined(&KVM_CAP_PIT_STATE2);
    }
    eval 'sub KVM_CAP_IOEVENTFD () {36;}' unless defined(&KVM_CAP_IOEVENTFD);
    eval 'sub KVM_CAP_SET_IDENTITY_MAP_ADDR () {37;}' unless defined(&KVM_CAP_SET_IDENTITY_MAP_ADDR);
    eval 'sub KVM_CAP_ADJUST_CLOCK () {39;}' unless defined(&KVM_CAP_ADJUST_CLOCK);
    if(defined(&__KVM_HAVE_VCPU_EVENTS)) {
	eval 'sub KVM_CAP_VCPU_EVENTS () {41;}' unless defined(&KVM_CAP_VCPU_EVENTS);
    }
    eval 'sub KVM_CAP_INTR_SHADOW () {49;}' unless defined(&KVM_CAP_INTR_SHADOW);
    if(defined(&KVM_CAP_IRQ_ROUTING)) {
	eval 'sub KVM_IRQ_ROUTING_IRQCHIP () {1;}' unless defined(&KVM_IRQ_ROUTING_IRQCHIP);
	eval 'sub KVM_IRQ_ROUTING_MSI () {2;}' unless defined(&KVM_IRQ_ROUTING_MSI);
    }
    eval 'sub KVM_CAP_S390_PSW () {42;}' unless defined(&KVM_CAP_S390_PSW);
    if(defined(&KVM_CAP_MCE)) {
    }
    eval 'sub KVM_IRQFD_FLAG_DEASSIGN () {(1<< 0);}' unless defined(&KVM_IRQFD_FLAG_DEASSIGN);
    eval 'sub KVM_SET_MEMORY_REGION () { &_IOW( &KVMIO, 0x40, \'struct kvm_memory_region\');}' unless defined(&KVM_SET_MEMORY_REGION);
    eval 'sub KVM_CREATE_VCPU () { &_IO( &KVMIO, 0x41);}' unless defined(&KVM_CREATE_VCPU);
    eval 'sub KVM_GET_DIRTY_LOG () { &_IOW( &KVMIO, 0x42, \'struct kvm_dirty_log\');}' unless defined(&KVM_GET_DIRTY_LOG);
    eval 'sub KVM_SET_MEMORY_ALIAS () { &_IOW( &KVMIO, 0x43, \'struct kvm_memory_alias\');}' unless defined(&KVM_SET_MEMORY_ALIAS);
    eval 'sub KVM_SET_NR_MMU_PAGES () { &_IO( &KVMIO, 0x44);}' unless defined(&KVM_SET_NR_MMU_PAGES);
    eval 'sub KVM_GET_NR_MMU_PAGES () { &_IO( &KVMIO, 0x45);}' unless defined(&KVM_GET_NR_MMU_PAGES);
    eval 'sub KVM_SET_USER_MEMORY_REGION () { &_IOW( &KVMIO, 0x46, \'struct kvm_userspace_memory_region\');}' unless defined(&KVM_SET_USER_MEMORY_REGION);
    eval 'sub KVM_SET_TSS_ADDR () { &_IO( &KVMIO, 0x47);}' unless defined(&KVM_SET_TSS_ADDR);
    eval 'sub KVM_SET_IDENTITY_MAP_ADDR () { &_IOW( &KVMIO, 0x48,  &__u64);}' unless defined(&KVM_SET_IDENTITY_MAP_ADDR);
    eval 'sub KVM_CREATE_IRQCHIP () { &_IO( &KVMIO, 0x60);}' unless defined(&KVM_CREATE_IRQCHIP);
    eval 'sub KVM_IRQ_LINE () { &_IOW( &KVMIO, 0x61, \'struct kvm_irq_level\');}' unless defined(&KVM_IRQ_LINE);
    eval 'sub KVM_GET_IRQCHIP () { &_IOWR( &KVMIO, 0x62, \'struct kvm_irqchip\');}' unless defined(&KVM_GET_IRQCHIP);
    eval 'sub KVM_SET_IRQCHIP () { &_IOR( &KVMIO, 0x63, \'struct kvm_irqchip\');}' unless defined(&KVM_SET_IRQCHIP);
    eval 'sub KVM_CREATE_PIT () { &_IO( &KVMIO, 0x64);}' unless defined(&KVM_CREATE_PIT);
    eval 'sub KVM_GET_PIT () { &_IOWR( &KVMIO, 0x65, \'struct kvm_pit_state\');}' unless defined(&KVM_GET_PIT);
    eval 'sub KVM_SET_PIT () { &_IOR( &KVMIO, 0x66, \'struct kvm_pit_state\');}' unless defined(&KVM_SET_PIT);
    eval 'sub KVM_IRQ_LINE_STATUS () { &_IOWR( &KVMIO, 0x67, \'struct kvm_irq_level\');}' unless defined(&KVM_IRQ_LINE_STATUS);
    eval 'sub KVM_REGISTER_COALESCED_MMIO () { &_IOW( &KVMIO, 0x67, \'struct kvm_coalesced_mmio_zone\');}' unless defined(&KVM_REGISTER_COALESCED_MMIO);
    eval 'sub KVM_UNREGISTER_COALESCED_MMIO () { &_IOW( &KVMIO, 0x68, \'struct kvm_coalesced_mmio_zone\');}' unless defined(&KVM_UNREGISTER_COALESCED_MMIO);
    eval 'sub KVM_ASSIGN_PCI_DEVICE () { &_IOR( &KVMIO, 0x69, \'struct kvm_assigned_pci_dev\');}' unless defined(&KVM_ASSIGN_PCI_DEVICE);
    eval 'sub KVM_SET_GSI_ROUTING () { &_IOW( &KVMIO, 0x6a, \'struct kvm_irq_routing\');}' unless defined(&KVM_SET_GSI_ROUTING);
    eval 'sub KVM_ASSIGN_IRQ () { &_IOR( &KVMIO, 0x70, \'struct kvm_assigned_irq\');}' unless defined(&KVM_ASSIGN_IRQ);
    eval 'sub KVM_ASSIGN_DEV_IRQ () { &_IOW( &KVMIO, 0x70, \'struct kvm_assigned_irq\');}' unless defined(&KVM_ASSIGN_DEV_IRQ);
    eval 'sub KVM_REINJECT_CONTROL () { &_IO( &KVMIO, 0x71);}' unless defined(&KVM_REINJECT_CONTROL);
    eval 'sub KVM_DEASSIGN_PCI_DEVICE () { &_IOW( &KVMIO, 0x72, \'struct kvm_assigned_pci_dev\');}' unless defined(&KVM_DEASSIGN_PCI_DEVICE);
    eval 'sub KVM_ASSIGN_SET_MSIX_NR () { &_IOW( &KVMIO, 0x73, \'struct kvm_assigned_msix_nr\');}' unless defined(&KVM_ASSIGN_SET_MSIX_NR);
    eval 'sub KVM_ASSIGN_SET_MSIX_ENTRY () { &_IOW( &KVMIO, 0x74, \'struct kvm_assigned_msix_entry\');}' unless defined(&KVM_ASSIGN_SET_MSIX_ENTRY);
    eval 'sub KVM_DEASSIGN_DEV_IRQ () { &_IOW( &KVMIO, 0x75, \'struct kvm_assigned_irq\');}' unless defined(&KVM_DEASSIGN_DEV_IRQ);
    eval 'sub KVM_IRQFD () { &_IOW( &KVMIO, 0x76, \'struct kvm_irqfd\');}' unless defined(&KVM_IRQFD);
    eval 'sub KVM_CREATE_PIT2 () { &_IOW( &KVMIO, 0x77, \'struct kvm_pit_config\');}' unless defined(&KVM_CREATE_PIT2);
    eval 'sub KVM_SET_BOOT_CPU_ID () { &_IO( &KVMIO, 0x78);}' unless defined(&KVM_SET_BOOT_CPU_ID);
    eval 'sub KVM_IOEVENTFD () { &_IOW( &KVMIO, 0x79, \'struct kvm_ioeventfd\');}' unless defined(&KVM_IOEVENTFD);
    eval 'sub KVM_SET_CLOCK () { &_IOW( &KVMIO, 0x7b, \'struct kvm_clock_data\');}' unless defined(&KVM_SET_CLOCK);
    eval 'sub KVM_GET_CLOCK () { &_IOR( &KVMIO, 0x7c, \'struct kvm_clock_data\');}' unless defined(&KVM_GET_CLOCK);
    eval 'sub KVM_RUN () { &_IO( &KVMIO, 0x80);}' unless defined(&KVM_RUN);
    eval 'sub KVM_GET_REGS () { &_IOR( &KVMIO, 0x81, \'struct kvm_regs\');}' unless defined(&KVM_GET_REGS);
    eval 'sub KVM_SET_REGS () { &_IOW( &KVMIO, 0x82, \'struct kvm_regs\');}' unless defined(&KVM_SET_REGS);
    eval 'sub KVM_GET_SREGS () { &_IOR( &KVMIO, 0x83, \'struct kvm_sregs\');}' unless defined(&KVM_GET_SREGS);
    eval 'sub KVM_SET_SREGS () { &_IOW( &KVMIO, 0x84, \'struct kvm_sregs\');}' unless defined(&KVM_SET_SREGS);
    eval 'sub KVM_TRANSLATE () { &_IOWR( &KVMIO, 0x85, \'struct kvm_translation\');}' unless defined(&KVM_TRANSLATE);
    eval 'sub KVM_INTERRUPT () { &_IOW( &KVMIO, 0x86, \'struct kvm_interrupt\');}' unless defined(&KVM_INTERRUPT);
    eval 'sub KVM_DEBUG_GUEST () { &__KVM_DEPRECATED_DEBUG_GUEST;}' unless defined(&KVM_DEBUG_GUEST);
    eval 'sub KVM_GET_MSRS () { &_IOWR( &KVMIO, 0x88, \'struct kvm_msrs\');}' unless defined(&KVM_GET_MSRS);
    eval 'sub KVM_SET_MSRS () { &_IOW( &KVMIO, 0x89, \'struct kvm_msrs\');}' unless defined(&KVM_SET_MSRS);
    eval 'sub KVM_SET_CPUID () { &_IOW( &KVMIO, 0x8a, \'struct kvm_cpuid\');}' unless defined(&KVM_SET_CPUID);
    eval 'sub KVM_SET_SIGNAL_MASK () { &_IOW( &KVMIO, 0x8b, \'struct kvm_signal_mask\');}' unless defined(&KVM_SET_SIGNAL_MASK);
    eval 'sub KVM_GET_FPU () { &_IOR( &KVMIO, 0x8c, \'struct kvm_fpu\');}' unless defined(&KVM_GET_FPU);
    eval 'sub KVM_SET_FPU () { &_IOW( &KVMIO, 0x8d, \'struct kvm_fpu\');}' unless defined(&KVM_SET_FPU);
    eval 'sub KVM_GET_LAPIC () { &_IOR( &KVMIO, 0x8e, \'struct kvm_lapic_state\');}' unless defined(&KVM_GET_LAPIC);
    eval 'sub KVM_SET_LAPIC () { &_IOW( &KVMIO, 0x8f, \'struct kvm_lapic_state\');}' unless defined(&KVM_SET_LAPIC);
    eval 'sub KVM_SET_CPUID2 () { &_IOW( &KVMIO, 0x90, \'struct kvm_cpuid2\');}' unless defined(&KVM_SET_CPUID2);
    eval 'sub KVM_GET_CPUID2 () { &_IOWR( &KVMIO, 0x91, \'struct kvm_cpuid2\');}' unless defined(&KVM_GET_CPUID2);
    eval 'sub KVM_TPR_ACCESS_REPORTING () { &_IOWR( &KVMIO, 0x92, \'struct kvm_tpr_access_ctl\');}' unless defined(&KVM_TPR_ACCESS_REPORTING);
    eval 'sub KVM_SET_VAPIC_ADDR () { &_IOW( &KVMIO, 0x93, \'struct kvm_vapic_addr\');}' unless defined(&KVM_SET_VAPIC_ADDR);
    eval 'sub KVM_S390_INTERRUPT () { &_IOW( &KVMIO, 0x94, \'struct kvm_s390_interrupt\');}' unless defined(&KVM_S390_INTERRUPT);
    eval 'sub KVM_S390_STORE_STATUS_NOADDR () {(-1);}' unless defined(&KVM_S390_STORE_STATUS_NOADDR);
    eval 'sub KVM_S390_STORE_STATUS_PREFIXED () {(-2);}' unless defined(&KVM_S390_STORE_STATUS_PREFIXED);
    eval 'sub KVM_S390_STORE_STATUS () { &_IOW( &KVMIO, 0x95, \'unsigned long\');}' unless defined(&KVM_S390_STORE_STATUS);
    eval 'sub KVM_S390_SET_INITIAL_PSW () { &_IOW( &KVMIO, 0x96, \'struct kvm_s390_psw\');}' unless defined(&KVM_S390_SET_INITIAL_PSW);
    eval 'sub KVM_S390_INITIAL_RESET () { &_IO( &KVMIO, 0x97);}' unless defined(&KVM_S390_INITIAL_RESET);
    eval 'sub KVM_GET_MP_STATE () { &_IOR( &KVMIO, 0x98, \'struct kvm_mp_state\');}' unless defined(&KVM_GET_MP_STATE);
    eval 'sub KVM_SET_MP_STATE () { &_IOW( &KVMIO, 0x99, \'struct kvm_mp_state\');}' unless defined(&KVM_SET_MP_STATE);
    eval 'sub KVM_NMI () { &_IO( &KVMIO, 0x9a);}' unless defined(&KVM_NMI);
    eval 'sub KVM_SET_GUEST_DEBUG () { &_IOW( &KVMIO, 0x9b, \'struct kvm_guest_debug\');}' unless defined(&KVM_SET_GUEST_DEBUG);
    eval 'sub KVM_X86_SETUP_MCE () { &_IOW( &KVMIO, 0x9c,  &__u64);}' unless defined(&KVM_X86_SETUP_MCE);
    eval 'sub KVM_X86_GET_MCE_CAP_SUPPORTED () { &_IOR( &KVMIO, 0x9d,  &__u64);}' unless defined(&KVM_X86_GET_MCE_CAP_SUPPORTED);
    eval 'sub KVM_X86_SET_MCE () { &_IOW( &KVMIO, 0x9e, \'struct kvm_x86_mce\');}' unless defined(&KVM_X86_SET_MCE);
    eval 'sub __KVM_DEPRECATED_DEBUG_GUEST () { &_IOW( &KVMIO, 0x87, \'struct kvm_debug_guest\');}' unless defined(&__KVM_DEPRECATED_DEBUG_GUEST);
    eval 'sub KVM_IA64_VCPU_GET_STACK () { &_IOR( &KVMIO, 0x9a,  &void *);}' unless defined(&KVM_IA64_VCPU_GET_STACK);
    eval 'sub KVM_IA64_VCPU_SET_STACK () { &_IOW( &KVMIO, 0x9b,  &void *);}' unless defined(&KVM_IA64_VCPU_SET_STACK);
    eval 'sub KVM_GET_VCPU_EVENTS () { &_IOR( &KVMIO, 0x9f, \'struct kvm_vcpu_events\');}' unless defined(&KVM_GET_VCPU_EVENTS);
    eval 'sub KVM_SET_VCPU_EVENTS () { &_IOW( &KVMIO, 0xa0, \'struct kvm_vcpu_events\');}' unless defined(&KVM_SET_VCPU_EVENTS);
    eval 'sub KVM_GET_PIT2 () { &_IOR( &KVMIO, 0x9f, \'struct kvm_pit_state2\');}' unless defined(&KVM_GET_PIT2);
    eval 'sub KVM_SET_PIT2 () { &_IOW( &KVMIO, 0xa0, \'struct kvm_pit_state2\');}' unless defined(&KVM_SET_PIT2);
    eval 'sub KVM_TRC_INJ_VIRQ () {( &KVM_TRC_HANDLER + 0x2);}' unless defined(&KVM_TRC_INJ_VIRQ);
    eval 'sub KVM_TRC_REDELIVER_EVT () {( &KVM_TRC_HANDLER + 0x3);}' unless defined(&KVM_TRC_REDELIVER_EVT);
    eval 'sub KVM_TRC_PEND_INTR () {( &KVM_TRC_HANDLER + 0x4);}' unless defined(&KVM_TRC_PEND_INTR);
    eval 'sub KVM_TRC_IO_READ () {( &KVM_TRC_HANDLER + 0x5);}' unless defined(&KVM_TRC_IO_READ);
    eval 'sub KVM_TRC_IO_WRITE () {( &KVM_TRC_HANDLER + 0x6);}' unless defined(&KVM_TRC_IO_WRITE);
    eval 'sub KVM_TRC_CR_READ () {( &KVM_TRC_HANDLER + 0x7);}' unless defined(&KVM_TRC_CR_READ);
    eval 'sub KVM_TRC_CR_WRITE () {( &KVM_TRC_HANDLER + 0x8);}' unless defined(&KVM_TRC_CR_WRITE);
    eval 'sub KVM_TRC_DR_READ () {( &KVM_TRC_HANDLER + 0x9);}' unless defined(&KVM_TRC_DR_READ);
    eval 'sub KVM_TRC_DR_WRITE () {( &KVM_TRC_HANDLER + 0xa);}' unless defined(&KVM_TRC_DR_WRITE);
    eval 'sub KVM_TRC_MSR_READ () {( &KVM_TRC_HANDLER + 0xb);}' unless defined(&KVM_TRC_MSR_READ);
    eval 'sub KVM_TRC_MSR_WRITE () {( &KVM_TRC_HANDLER + 0xc);}' unless defined(&KVM_TRC_MSR_WRITE);
    eval 'sub KVM_TRC_CPUID () {( &KVM_TRC_HANDLER + 0xd);}' unless defined(&KVM_TRC_CPUID);
    eval 'sub KVM_TRC_INTR () {( &KVM_TRC_HANDLER + 0xe);}' unless defined(&KVM_TRC_INTR);
    eval 'sub KVM_TRC_NMI () {( &KVM_TRC_HANDLER + 0xf);}' unless defined(&KVM_TRC_NMI);
    eval 'sub KVM_TRC_VMMCALL () {( &KVM_TRC_HANDLER + 0x10);}' unless defined(&KVM_TRC_VMMCALL);
    eval 'sub KVM_TRC_HLT () {( &KVM_TRC_HANDLER + 0x11);}' unless defined(&KVM_TRC_HLT);
    eval 'sub KVM_TRC_CLTS () {( &KVM_TRC_HANDLER + 0x12);}' unless defined(&KVM_TRC_CLTS);
    eval 'sub KVM_TRC_LMSW () {( &KVM_TRC_HANDLER + 0x13);}' unless defined(&KVM_TRC_LMSW);
    eval 'sub KVM_TRC_APIC_ACCESS () {( &KVM_TRC_HANDLER + 0x14);}' unless defined(&KVM_TRC_APIC_ACCESS);
    eval 'sub KVM_TRC_TDP_FAULT () {( &KVM_TRC_HANDLER + 0x15);}' unless defined(&KVM_TRC_TDP_FAULT);
    eval 'sub KVM_TRC_GTLB_WRITE () {( &KVM_TRC_HANDLER + 0x16);}' unless defined(&KVM_TRC_GTLB_WRITE);
    eval 'sub KVM_TRC_STLB_WRITE () {( &KVM_TRC_HANDLER + 0x17);}' unless defined(&KVM_TRC_STLB_WRITE);
    eval 'sub KVM_TRC_STLB_INVAL () {( &KVM_TRC_HANDLER + 0x18);}' unless defined(&KVM_TRC_STLB_INVAL);
    eval 'sub KVM_TRC_PPC_INSTR () {( &KVM_TRC_HANDLER + 0x19);}' unless defined(&KVM_TRC_PPC_INSTR);
    eval 'sub KVM_DEV_ASSIGN_ENABLE_IOMMU () {(1<< 0);}' unless defined(&KVM_DEV_ASSIGN_ENABLE_IOMMU);
    eval 'sub KVM_DEV_IRQ_HOST_INTX () {(1<< 0);}' unless defined(&KVM_DEV_IRQ_HOST_INTX);
    eval 'sub KVM_DEV_IRQ_HOST_MSI () {(1<< 1);}' unless defined(&KVM_DEV_IRQ_HOST_MSI);
    eval 'sub KVM_DEV_IRQ_HOST_MSIX () {(1<< 2);}' unless defined(&KVM_DEV_IRQ_HOST_MSIX);
    eval 'sub KVM_DEV_IRQ_GUEST_INTX () {(1<< 8);}' unless defined(&KVM_DEV_IRQ_GUEST_INTX);
    eval 'sub KVM_DEV_IRQ_GUEST_MSI () {(1<< 9);}' unless defined(&KVM_DEV_IRQ_GUEST_MSI);
    eval 'sub KVM_DEV_IRQ_GUEST_MSIX () {(1<< 10);}' unless defined(&KVM_DEV_IRQ_GUEST_MSIX);
    eval 'sub KVM_DEV_IRQ_HOST_MASK () {0xff;}' unless defined(&KVM_DEV_IRQ_HOST_MASK);
    eval 'sub KVM_DEV_IRQ_GUEST_MASK () {0xff00;}' unless defined(&KVM_DEV_IRQ_GUEST_MASK);
    eval 'sub KVM_MAX_MSIX_PER_DEV () {256;}' unless defined(&KVM_MAX_MSIX_PER_DEV);
}
1;
