#!/bin/sh

if [ ! -n "$(type -t updateInstanceProperty)" ] && [ "$(type -t updateInstanceProperty)" != function ]; then
. /usr/local/horizon/scripts/manageTcCfg.inc
fi

#approved ciphers
APPROVED_CIPHERS="TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"

APPROVED_PROTOCOLS="TLSv1.2"

APPROVED_CURVES="secp521r1,secp384r1,secp256r1"

SSL_PROTCOL="TLS"

tomcat_protocols(){
    IFS=',' read -r -a protocols <<< "$APPROVED_PROTOCOLS"
    echo +$( IFS=$'+'; echo "${protocols[*]}" )
}

updateSSLConfig(){
    updateInstanceProperty $(getTemplateName).cipher.list "${APPROVED_CIPHERS}"
    updateInstanceProperty $(getTemplateName).ssl.protocols $(tomcat_protocols)
    updateInstanceProperty $(getTemplateName).ssl.protocol "${SSL_PROTCOL}"
}

