#!/bin/bash
# A router or firewall allows source routed packets from arbitrary hosts.

# http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-1999-0510
#
# Usage: CVE-1999-0510 [sysctl.conf]
set -e

trap Clean_up HUP INT QUIT TERM ERR EXIT

SCRIPT_NAME=$(basename "${0%.sh}")

SYSCTL_CONF=${1:-"/etc/sysctl.conf"}
GEN003600=./GEN003600.sh

if [ -e ${SYSCTL_CONF} ]
then
   # IPv4 options
   ${GEN003600} ${SYSCTL_CONF} "net.ipv4.conf.default.accept_source_route" 0
   ${GEN003600} ${SYSCTL_CONF} "net.ipv4.conf.all.accept_source_route" 0
   ${GEN003600} ${SYSCTL_CONF} "net.ipv4.conf.all.forwarding" 0
   ${GEN003600} ${SYSCTL_CONF} "net.ipv4.conf.all.mc_forwarding" 0

   # IPv6 options. Note this requires VMW-BZ-786734 for SLES.
   ${GEN003600} ${SYSCTL_CONF} "net.ipv6.conf.default.accept_source_route" 0
   ${GEN003600} ${SYSCTL_CONF} "net.ipv6.conf.all.accept_source_route" 0
   ${GEN003600} ${SYSCTL_CONF} "net.ipv6.conf.all.forwarding" 0
fi

# ensure that IPV6_FORWARD is set to 'no' within /etc/sysconfig/sysctl
if [ -e /etc/sysconfig/sysctl ]
then
   sed -i "s|IPV6_FORWARD=\(.*\)|IPV6_FORWARD=\"no\"|" /etc/sysconfig/sysctl
fi
