#!/bin/bash
# This scripts reads a file which specifies "<path>:<max_perm>"
# entries, and strips off any extra perms it may have
set -e

SCRIPT_NAME=$(basename "${0%.sh}")

LISTFILE=${1:-ChmodList}

grep -v "^#" $LISTFILE | while read LINE
do
   FILE=`echo $LINE | cut -d':' -f1`
   MAX_PERM=`echo $LINE | cut -d':' -f2`
   # Strip away only extra perm
   if [ -e $FILE ]; then
      ACTUAL_PERM=0`stat -c %a $FILE`
      EXTRA_PERM=0`printf "%o" $(( 0777 - 0$MAX_PERM ))`
      # AND with the above mask to remove the extra perms
      REQ_PERM=`printf "%o" $(( $ACTUAL_PERM & ~$EXTRA_PERM ))`
      chmod $REQ_PERM $FILE
   else
      echo "$SCRIPT_NAME: Skip $FILE. File does not exist" >&2
   fi
done
