#!/bin/bash
#
# Fixes for GEN000240, GEN000241, GEN000242
#

NTP_CONF='/etc/ntp.conf'
if [ -e $NTP_CONF ]
then
   grep '^[#]*server time.nist.gov burst iburst' $NTP_CONF > /dev/null
   if [ $? -ne 0 ]
   then
      sed -i "42a#server time.nist.gov burst iburst" $NTP_CONF
   else
      grep '^server time.nist.gov burst iburst' $NTP_CONF > /dev/null
      if [ $? -eq 0 ]
      then
         sed -i "/^server time.nist.gov burst iburst/ c\#server time.nist.gov burst iburst" $NTP_CONF
      fi
   fi
fi

FILE="/etc/cron.d/timesync"

if [ -f "$FILE" ]
then
   rm -rf $FILE
   echo "#59 * * * * root /usr/sbin/ntpd -qg >/dev/null 2>&1" >> $FILE
   chmod 600 $FILE
else
   touch $FILE
   echo "#59 * * * * root /usr/sbin/ntpd -qg >/dev/null 2>&1" >> $FILE
   chmod 600 $FILE
fi

