#!/bin/bash
# This script sets the max password lifetime to 60 days

sed -i "/^[^#]*PASS_MAX_DAYS/ c\PASS_MAX_DAYS   60" /etc/login.defs

cat /etc/passwd | awk -F: '{print$1}' |\

while read name
do

  uname=`cat /etc/shadow | grep $name | awk -F":" '{print}'`
  MAX_AGE=`echo -e $uname | awk -F: '{print$5}'`

  if [ "$MAX_AGE" != "60" ]
  then
     /usr/bin/passwd -x 60 $name
  else
     exit
  fi
done
