#!/bin/bash
# This script sets up PAM
#
# GEN000600-2 fix for sym-links to prevent overwrite
#

rm -rf /etc/pam.d/common-account
cp /etc/pam.d/common-account-pc /etc/pam.d/common-account-vmware.local
chmod 0644 /etc/pam.d/common-account-vmware.local
ln -s /etc/pam.d/common-account-vmware.local /etc/pam.d/common-account

rm -rf /etc/pam.d/common-auth
cp /etc/pam.d/common-auth-pc /etc/pam.d/common-auth-vmware.local
chmod 0644 /etc/pam.d/common-auth-vmware.local
ln -s /etc/pam.d/common-auth-vmware.local /etc/pam.d/common-auth

rm -rf /etc/pam.d/common-password
cp /etc/pam.d/common-password-pc /etc/pam.d/common-password-vmware.local
chmod 0644 /etc/pam.d/common-password-vmware.local
ln -s /etc/pam.d/common-password-vmware.local /etc/pam.d/common-password

rm -rf /etc/pam.d/common-session
cp /etc/pam.d/common-session-pc /etc/pam.d/common-session-vmware.local
chmod 0644 /etc/pam.d/common-session-vmware.local
ln -s /etc/pam.d/common-session-vmware.local /etc/pam.d/common-session

#
# Fix for su -c commands to work properly without pam_lastlog entry
#
cp /etc/pam.d/common-session-pc /etc/pam.d/common-session-su
chmod 0644 /etc/pam.d/common-session-su

if [ -e /etc/pam.d/su ]
then
   PAMSUCHECK=`egrep -c common-session /etc/pam.d/su`

   if [ $PAMSUCHECK -eq 0 ]
   then
      sed -i "7asession\tinclude \tcommon-session-su" /etc/pam.d/su
   else
      sed -i "/^[^#]*common-session/ c\session\tinclude \tcommon-session-su" /etc/pam.d/su
   fi
fi

if [ -e /etc/pam.d/crond ]
then
   PAMCRONCHECK=`egrep -c common-session /etc/pam.d/crond`

   if [ $PAMCRONCHECK -eq 0 ]
   then
      sed -i "9asession\tinclude \tcommon-session-su" /etc/pam.d/crond
   else
      sed -i "/^[^#]*common-session/ c\session\tinclude \tcommon-session-su" /etc/pam.d/crond
   fi
fi

if [ -e /etc/pam.d/sudo ]
then
   PAMSUDOCHECK=`egrep -c common-session /etc/pam.d/sudo`

   if [ $PAMSUDOCHECK -eq 0 ]
   then
      sed -i "4asession\tinclude \tcommon-session-su" /etc/pam.d/sudo
   else
      sed -i "/^[^#]*common-session/ c\session\tinclude \tcommon-session-su" /etc/pam.d/sudo
   fi
fi

#
# GEN000600, 610, 620, 640, 750, 790 fixes for password compliance checks
#

PAMPWCHECK=`egrep -c pam_pwcheck.so /etc/pam.d/common-password-vmware.local`
PAMCRACKLIBCHECK=`egrep -c "requisite|pam_cracklib.so" /etc/pam.d/common-password-vmware.local`
PAMCRACKSETCHECK=`egrep -c "required|pam_cracklib.so" /etc/pam.d/common-password-vmware.local`

if [ $PAMPWCHECK -ne 0 ]
then
   sed -i "/^[^#]*pam_pwcheck.so/ c\password\trequisite\tpam_cracklib.so\tdcredit=-1 ucredit=-1 lcredit=-1 ocredit=-1 minlen=8 difok=4 retry=3" /etc/pam.d/common-password-vmware.local
fi

if [ $PAMCRACKLIBCHECK -ne 0 ]
then
   sed -i "/^[^#]*password\trequisite\tpam_cracklib.so/ c\password\trequisite\tpam_cracklib.so\tdcredit=-1 ucredit=-1 lcredit=-1 ocredit=-1 minlen=8 difok=4 retry=3" /etc/pam.d/common-password-vmware.local
fi

if [ $PAMCRACKSETCHECK -ne 0 ]
then
   sed -i "/^[^#]*password\trequired\tpam_cracklib.so/ c\password\trequisite\tpam_cracklib.so\tdcredit=-1 ucredit=-1 lcredit=-1 ocredit=-1 minlen=8 difok=4 retry=3" /etc/pam.d/common-password-vmware.local
fi

#
# GEN000480 fix for fail_delay
#

PAMFAILCHECK=`egrep -c pam_faildelay.so /etc/pam.d/common-auth-vmware.local`

if [ $PAMFAILCHECK -eq 0 ]
then
   echo -e "auth\toptional\tpam_faildelay.so" >> /etc/pam.d/common-auth-vmware.local
else
   sed -i "/^[^#]*pam_faildelay.so/ c\auth\toptional\tpam_faildelay.so" /etc/pam.d/common-auth-vmware.local
fi

#
# GEN000454 fix for lastlog
#

PAMLASTLOGCHECK=`egrep -c pam_lastlog.so /etc/pam.d/common-session-vmware.local`

if [ $PAMLASTLOGCHECK -eq 0 ]
then
   echo -e "session\trequired\tpam_lastlog.so showfailed" >> /etc/pam.d/common-session-vmware.local
else
   sed -i "/^[^#]*pam_lastlog.so/ c\session\trequired\tpam_lastlog.so showfailed" /etc/pam.d/common-session-vmware.local
fi

sed -i '/pam_lastlog.so/d' /etc/pam.d/login

#
# GEN000460 fix for password tally
#

PAMTALLYLOGINCHECK=`egrep -c pam_tally.so /etc/pam.d/login`

if [ $PAMTALLYLOGINCHECK -ne 0 ]
then
   sed -i '/pam_tally.so/d' /etc/pam.d/login
fi

PAMTALLYSSHCHECK=`egrep -c pam_tally.so /etc/pam.d/sshd`

if [ $PAMTALLYSSHCHECK -ne 0 ]
then
   sed -i '/pam_tally.so/d' /etc/pam.d/sshd
fi

PAMTALLY2AUTHCHECK=`egrep -c pam_tally2.so /etc/pam.d/common-auth-vmware.local`

if [ $PAMTALLY2AUTHCHECK -eq 0 ]
then
   echo "auth    required       pam_tally2.so deny=3 onerr=fail even_deny_root unlock_time=86400 root_unlock_time=300" >> /etc/pam.d/common-auth-vmware.local
else
   sed -i "/^.*auth.*pam_tally2.so/ c\auth\trequired\tpam_tally2.so deny=3 onerr=fail even_deny_root unlock_time=86400 root_unlock_time=300" /etc/pam.d/common-auth-vmware.local
fi

PAMTALLY2ACCOUNTCHECK=`egrep -c pam_tally2.so /etc/pam.d/common-account-vmware.local`

if [ $PAMTALLY2ACCOUNTCHECK -eq 0 ]
then
   echo "account required       pam_tally2.so" >> /etc/pam.d/common-account-vmware.local
else
   sed -i "/^.*account.*pam_tally2.so/ c\account\trequired\tpam_tally2.so" /etc/pam.d/common-account-vmware.local
fi

#
# GEN000800 fix for password history
#

PAMPWHISTCHECK=`egrep -c pam_pwhistory.so /etc/pam.d/common-password-vmware.local`

if [ $PAMPWHISTCHECK -eq 0 ]
then
   sed -i '/pam_cracklib.so/ a\
password\trequired\tpam_pwhistory.so enforce_for_root remember=5 retry=3' /etc/pam.d/common-password-vmware.local
else
   sed -i "/^[^#]*pam_pwhistory.so/ c\password\trequired\tpam_pwhistory.so enforce_for_root remember=5 retry=3" /etc/pam.d/common-password-vmware.local
fi

#
# GEN000850 fix for securing su to wheel group
#

if [ -e /etc/pam.d/su ]
then
   PAMSUWHEELCHECK=`egrep -c pam_wheel.so /etc/pam.d/su`

   if [ $PAMSUWHEELCHECK -eq 0 ]
   then
      sed -i "2aauth\trequired\tpam_wheel.so use_uid" /etc/pam.d/su
   else
      sed -i "/^[^#]*pam_wheel.so/ c\auth\trequired\tpam_wheel.so use_uid" /etc/pam.d/su
   fi
fi

if [ -e /etc/pam.d/su-l ]
then
   PAMSULWHEELCHECK=`egrep -c pam_wheel.so /etc/pam.d/su-l`

   if [ $PAMSULWHEELCHECK -eq 0 ]
   then
      sed -i "2aauth\trequired\tpam_wheel.so use_uid" /etc/pam.d/su-l
   else
      sed -i "/^[^#]*pam_wheel.so/ c\auth\trequired\tpam_wheel.so use_uid" /etc/pam.d/su-l
   fi
fi

if [ -e /usr/sbin/pam-config ]
then
   chmod 000 /usr/sbin/pam-config
fi
