#!/bin/bash
#
# Set the sshd_config PermitRootLogin flag to no
#

SSHFILE=/etc/ssh/sshd_config

grep '^[#]*PermitRootLogin' $SSHFILE > /dev/null
if [ $? -ne 0 ]
then
   # This is a sanity check just in case the line is missing in global settings
   # Line 40 is the current location in SP2 and SP3
   sed -i "39aPermitRootLogin no" $SSHFILE
else
   # This ensures the global setting is changed only
   # Dev teams may set match options at the end of the config file to restrict
   #  the use of root login to a specific interface
   sed -i '0,/.*PermitRootLogin.*/s/.*PermitRootLogin.*/PermitRootLogin no/' $SSHFILE
fi
