#!/bin/bash
# This scripts corrects the permissions of all system log files which have
# perms greater than 640

DIRS="\
/var/log/"

for i in `ls -d ${DIRS}` ; do
   /usr/bin/find $i -type f -perm /o+r ! -iname wtmp 2>/dev/null -exec chmod 640 {} \;
done;

BOOT_KLOG='/etc/rc.d/boot.klog'
if [ -e $BOOT_KLOG ]
then
   BOOTPERM=`egrep -c 'chmod 640 /var/log/boot.msg' $BOOT_KLOG`

   if [ $BOOTPERM -eq 0 ]
   then
      sed -i '/IO \/sbin\/blogd/ a\    chmod 640 \/var\/log\/boot.msg' $BOOT_KLOG
   fi
fi
