#!/bin/bash
# This script checks and sets command file permissions to 755

ERLANGDIRS="\
/usr/lib64/erlang/lib"

if [ ! -e $ERLANGDIRS ]
then
   echo "There is no erland exist on the system. No action required."
   exit 0
fi

LIBDIRS="\
/lib
/lib64
/usr/lib
/usr/lib64"

for i in `ls -d $LIBDIRS 2> /dev/null`
do
   for x in `find $i \( -type f -perm /022 -a ! -wholename \*usr/lib64/erlang\* \) -exec stat -c %n {} \;`
   do
      chmod 755 $x
   done
done

for i in $ERLANGDIRS
do
   for x in `find $i -type f -perm /022 -exec stat -c %n {} \;`
   do
      chmod 644 $x
   done
done
