#!/bin/bash
#
# This script sets the default useradd umask to 027 for home directories
#
USERADD="/etc/default/useradd"

grep ^[^#]*UMASK $USERADD > /dev/null
   if [ $? -eq 0 ]
   then
      grep ^[^#]*UMASK.*027 $USERADD > /dev/null
      if [ $? -ne 0 ]
      then
         sed -i "/^[^#]*UMASK/ c\UMASK=027" $USERADD
      fi
   else
      echo "UMASK=027" >> $USERADD
   fi
