#!/bin/bash
#

DIR="/var/log/devicelist"

if [ -d "$DIR" ]
then
   chmod 700 $DIR
else
   mkdir -p $DIR
   chmod 700 $DIR
fi

FILE="/etc/cron.weekly/devcheck"

if [ -f "$FILE" ]
then
   egrep -e '^*devicelist' $FILE > /dev/null
   if [ $? -ne 0 ]
   then
      echo "/usr/bin/find / -type b -o -type c > /var/log/devicelist/device_list.\$(date +%m%d%Y-%H%M%S)" >> $FILE
   fi
else
   echo "/usr/bin/find / -type b -o -type c > /var/log/devicelist/device_list.\$(date +%m%d%Y-%H%M%S)" >> $FILE
   chmod 700 $FILE
fi
