#!/bin/bash
#

/usr/bin/find / \( -fstype nfs -o -fstype cifs -o -fstype nfs4 -o -fstype nfsd \) -prune -o -perm -2 -a \( -type b -o -type c \) -a ! -wholename \*dev/null\* -a ! -wholename \*dev/vsock\* -a ! -wholename \*dev/tty\* -a ! -wholename \*dev/zero\* -a ! -wholename \*dev/ptmx\* -a ! -wholename \*dev/full\* 2>/dev/null -exec chmod o-w {} \;

RANDOMUDEV=/etc/udev/rules.d/99-vmware-udev.rules

if [ -f $RANDOMUDEV ]
then
   sed -i "/^[^#]*KERNEL/ c\KERNEL==\"random|urandom\", MODE=\"0644\"" $RANDOMUDEV
else
   touch $RANDOMUDEV
   chown root:root $RANDOMUDEV
   chmod 644 $RANDOMUDEV
   echo "# do not edit this file, it will be overwritten on update

# mem
KERNEL==\"random|urandom\", MODE=\"0644\"
" >> $RANDOMUDEV
fi
