#!/bin/bash
#

DIR="/var/log/suidlist"

if [ -d "$DIR" ]
then
   chmod 700 $DIR
else
   mkdir -p $DIR
   chmod 700 $DIR
fi

FILE="/etc/cron.weekly/suidcheck"

if [ -f "$FILE" ]
then
   egrep -e '^*suidlist' $FILE > /dev/null
   if [ $? -ne 0 ]
   then
      echo "/usr/bin/find / -perm -4000 2>/dev/null > /var/log/suidlist/suid_list.\$(date +%m%d%Y-%H%M%S)" >> $FILE
   fi
else
   echo "/usr/bin/find / -perm -4000 2>/dev/null > /var/log/suidlist/suid_list.\$(date +%m%d%Y-%H%M%S)" >> $FILE
   chmod 700 $FILE
fi
