#!/bin/bash

#######################DISA INFORMATION###############################
##
## (GEN002420: CAT II)  The SA will ensure user filesystems,
## removable media, and remote filesystems will be mounted with the nosuid
## option.
##
## (GEN002430: CAT II) Removable media, remote file systems, and any file
## system that does not contain approved device files must be mounted with
## the "nodev" option.
##
#######################DISA INFORMATION###############################
echo '==================================================='
echo ' Patching GEN002420: Mount filesystems with nosuid'
echo '==================================================='
echo '==================================================='
echo ' Patching GEN002430: Mount filesystems with nodev'
echo '==================================================='

FSTAB=/etc/fstab
FSTMP=/etc/fstab.FIX

awk '
{
   if ($2 ~ /(\/$)/)
   {
      $4="defaults";
   }

   else if ($2 ~ /(\/boot$)/)
   {
      $4="defaults,nosuid,noacl,nodev,noexec";
   }

   else if ($2 !~ /(\/tmp$|\/var$|\/usr$|\/sys|\/proc|\/dev|swap|none|^$)/)
   {
      if ($4 == "defaults")
      {
         $4="rw,nosuid,nodev,exec,auto,nouser,async";
      }

      if (!sub(/\<suid\>/,"nosuid",$4) && $4 !~ /\<nosuid\>/)
      {
         $4=$4",nosuid";
      }

      if (!sub(/\<dev\>/,"nodev",$4) && $4 !~ /\<nodev\>/)
      {
         $4=$4",nodev";
      }
   }
print $0;
}
' $FSTAB >> $FSTMP
chmod 0600 $FSTMP
mv $FSTMP $FSTAB

FSLIST=$(awk '{
   if ($2 !~ /(\/tmp$|\/var$|\/usr$|\/sys|\/proc|\/dev|swap|none|^$)/)
   {
        print $2
   }
}' $FSTAB)

for i in $FSLIST
do
      mount -v -o remount $i
done
