#!/bin/bash
#

DIR="/var/log/sgidlist"

if [ -d "$DIR" ]
then
   chmod 700 $DIR
else
   mkdir -p $DIR
   chmod 700 $DIR
fi

FILE="/etc/cron.weekly/sgidcheck"

if [ -f "$FILE" ]
then
   egrep -e '^*sgidlist' $FILE > /dev/null
   if [ $? -ne 0 ]
   then
      echo "/usr/bin/find / -perm -2000 2>/dev/null > /var/log/sgidlist/sgid_list.\$(date +%m%d%Y-%H%M%S)" >> $FILE
   fi
else
   echo "/usr/bin/find / -perm -2000 2>/dev/null > /var/log/sgidlist/sgid_list.\$(date +%m%d%Y-%H%M%S)" >> $FILE
   chmod 700 $FILE
fi
