#!/bin/bash
#
# Set the audit rules to audit open
#

OPENCHECK=`egrep -c '*-S open' /etc/audit/audit.rules`
if [ $OPENCHECK -eq 0 ]
then
   echo "-a exit,never -F arch=b64 -S open -F success=1 -F exit=4" >> /etc/audit/audit.rules
   echo "-a exit,never -F arch=b64 -S open -F success=1 -F exit=5" >> /etc/audit/audit.rules
   echo "-a exit,always -F arch=b64 -S open -F exit=-EPERM" >> /etc/audit/audit.rules
   echo "-a exit,always -F arch=b64 -S open -F exit=-EACCES" >> /etc/audit/audit.rules
   echo "-a exit,always -F arch=b32 -S open -F exit=-EPERM" >> /etc/audit/audit.rules
   echo "-a exit,always -F arch=b32 -S open -F exit=-EACCES" >> /etc/audit/audit.rules
else
   sed -i '/open/d' /etc/audit/audit.rules
   echo "-a exit,never -F arch=b64 -S open -F success=1 -F exit=4" >> /etc/audit/audit.rules
   echo "-a exit,never -F arch=b64 -S open -F success=1 -F exit=5" >> /etc/audit/audit.rules
   echo "-a exit,always -F arch=b64 -S open -F exit=-EPERM" >> /etc/audit/audit.rules
   echo "-a exit,always -F arch=b64 -S open -F exit=-EACCES" >> /etc/audit/audit.rules
   echo "-a exit,always -F arch=b32 -S open -F exit=-EPERM" >> /etc/audit/audit.rules
   echo "-a exit,always -F arch=b32 -S open -F exit=-EACCES" >> /etc/audit/audit.rules
fi
