#!/bin/bash
#
# Set the audit rules to audit unlink and rmdir
#

UNLINKCHECK=`egrep -c '*-S unlink' /etc/audit/audit.rules`
if [ $UNLINKCHECK -eq 0 ]
then
   echo "
-a exit,always -F arch=b64 -S unlink -F exit=-EPERM
-a exit,always -F arch=b64 -S unlink -F exit=-EACCES
-a exit,always -F arch=b32 -S unlink -F exit=-EPERM
-a exit,always -F arch=b32 -S unlink -F exit=-EACCES
" >> /etc/audit/audit.rules
else
   sed -i '/unlink/d' /etc/audit/audit.rules
   echo "
-a exit,always -F arch=b64 -S unlink -F exit=-EPERM
-a exit,always -F arch=b64 -S unlink -F exit=-EACCES
-a exit,always -F arch=b32 -S unlink -F exit=-EPERM
-a exit,always -F arch=b32 -S unlink -F exit=-EACCES
" >> /etc/audit/audit.rules
fi
