#!/bin/bash
#
# Set the audit rules to write to audit rules, check audit config file, and
# set basic audit rules via GEN002760, -2, -4, -8, -9, -10
#

AUDCONFCHECK=`egrep -c '*auditd.conf' /etc/audit/audit.rules`
if [ $AUDCONFCHECK -eq 0 ]
then
   echo "-w /etc/audit/auditd.conf" >> /etc/audit/audit.rules
fi

AUDRULECHECK=`egrep -c '*audit.rules' /etc/audit/audit.rules`
if [ $AUDRULECHECK -eq 0 ]
then
   echo "-w /etc/audit/audit.rules" >> /etc/audit/audit.rules
fi

AUDRMDIRCHECK=`egrep -c '*-S rmdir' /etc/audit/audit.rules`
if [ $AUDRMDIRCHECK -eq 0 ]
then
   echo "
-a exit,always -F arch=b64 -S rmdir -F success!=1 -F exit!=0
-a exit,always -F arch=b32 -S rmdir
" >> /etc/audit/audit.rules
else
   sed -i '/rmdir/d' /etc/audit/audit.rules
   echo "
-a exit,always -F arch=b64 -S rmdir -F success!=1 -F exit!=0
-a exit,always -F arch=b32 -S rmdir
" >> /etc/audit/audit.rules
fi

AUDF32CHECK=`egrep -c '*arch=b32 -S stime -S acct' /etc/audit/audit.rules`
if [ $AUDF32CHECK -eq 0 ]
then
   echo "
-a exit,always -F arch=b32 -S stime -S acct -S reboot -S settimeofday -S setrlimit -S setdomainname -S sched_setparam -S sched_setscheduler
-a exit,always -F arch=b32 -S swapon -F exit=-EPERM
-a exit,always -F arch=b32 -S swapon -F exit=-EACCES
" >> /etc/audit/audit.rules
fi

AUDF64CHECK=`egrep -c '*arch=b64 -S acct -S reboot' /etc/audit/audit.rules`
if [ $AUDF64CHECK -eq 0 ]
then
   echo "
-a exit,always -F arch=b64 -S settimeofday -F success!=1 -F uid!=108
-a exit,always -F arch=b64 -S setrlimit -F success!=1 -F exit!=0
-a exit,always -F arch=b64 -S acct -S reboot -S setdomainname -S sched_setparam -S sched_setscheduler
-a exit,always -F arch=b64 -S swapon -F exit=-EPERM
-a exit,always -F arch=b64 -S swapon -F exit=-EACCES
" >> /etc/audit/audit.rules
fi
