#!/bin/bash
#

if [ -e /etc/audit/auditd.conf ]
then
   sed -i "/^[^#]*max_log_file_action/ c\max_log_file_action = IGNORE" /etc/audit/auditd.conf
fi

rm -rf /etc/logrotate.d/syslog
mkdir -p /etc/logrotate.d
touch /etc/logrotate.d/syslog
chmod 644 /etc/logrotate.d/syslog
chown root:root /etc/logrotate.d/syslog

echo "#
# Please note, that changing of log file permissions in this
# file is not sufficient if syslog-ng is used as log daemon.
#
# It is required to specify the permissions in the syslog-ng
# configuration file /etc/syslog-ng/syslog-ng.conf as well.
#
/var/log/warn /var/log/messages /var/log/ldapmessages /var/log/allmessages /var/log/localmessages /var/log/acpid /var/log/NetworkManager /var/log/mail /var/log/mail.info /var/log/mail.warn /var/log/mail.err /var/log/news/news.crit /var/log/news/news.err /var/log/news/news.notice {
    compress
    dateext
    rotate 15
    daily
    missingok
    notifempty
    create 640 root root
    sharedscripts
    postrotate
        /etc/init.d/syslog reload > /dev/null
    endscript
}

/var/log/cron /var/log/auth.log /var/log/btmp /var/log/faillog /var/log/firewall /var/log/sudolog /var/log/tallylog {
    compress
    dateext
    rotate 15
    daily
    missingok
    notifempty
    create 600 root root
    sharedscripts
    postrotate
        /etc/init.d/syslog reload > /dev/null
    endscript
}

/var/log/lastlog {
    compress
    dateext
    rotate 15
    daily
    missingok
    notifempty
    create 640 root tty
    sharedscripts
    postrotate
        /etc/init.d/syslog reload > /dev/null
    endscript
}
" >> /etc/logrotate.d/syslog

rm -rf /etc/logrotate.d/audit
touch /etc/logrotate.d/audit
chmod 644 /etc/logrotate.d/audit
chown root:root /etc/logrotate.d/audit

echo "#
# Please note, that changing of log file permissions in this
# file is not sufficient if syslog-ng is used as log daemon.
#
# It is required to specify the permissions in the syslog-ng
# configuration file /etc/syslog-ng/syslog-ng.conf as well.
#
/var/log/audit/audit.log {
    compress
    dateext
    rotate 15
    daily
    missingok
    notifempty
    create 600 root root
    sharedscripts
    postrotate
        /sbin/service auditd restart 2> /dev/null > /dev/null || true
    endscript
}
" >> /etc/logrotate.d/audit

rm -rf /etc/logrotate.d/ntp
touch /etc/logrotate.d/ntp
chmod 644 /etc/logrotate.d/ntp
chown root:root /etc/logrotate.d/ntp

echo "/var/log/ntp {
    compress
    dateext
    rotate 15
    daily
    missingok
    copytruncate
    postrotate
        chmod 640 /var/log/ntp
    endscript
}
" >> /etc/logrotate.d/ntp

FWFILE=/var/log/firewall

if [ -f $FWFILE ]
then
   chmod 600 $FWFILE
else
   touch $FWFILE
   chmod 600 $FWFILE
fi

SYSLOGNG=/etc/syslog-ng/syslog-ng.conf

if [ -f $SYSLOGNG ]
then
   FWCHECK1=`egrep -c "destination firewall" $SYSLOGNG`
   FWCHECK2=`egrep -c "log.*f_iptables" $SYSLOGNG`

   if [ $FWCHECK1 -ne 0 ]
   then
      grep '^#destination firewall' $SYSLOGNG > /dev/null
      if [ $? -eq 0 ]
      then
         sed -i "/^#destination firewall/ c\destination firewall { file(\"/var/log/firewall\" perm(0600)); };" $SYSLOGNG
      else
         sed -i "/^[^#]*destination firewall/ c\destination firewall { file(\"/var/log/firewall\" perm(0600)); };" $SYSLOGNG
      fi
   fi

   if [ $FWCHECK2 -ne 0 ]
   then
      grep '^#log.*f_iptables' $SYSLOGNG > /dev/null
      if [ $? -eq 0 ]
      then
         sed -i "/^#log.*f_iptables/ c\log { source(src); filter(f_iptables); destination(firewall); };" $SYSLOGNG
      else
         sed -i "/^[^#]*log.*f_iptables/ c\log { source(src); filter(f_iptables); destination(firewall); };" $SYSLOGNG
      fi
   fi
fi

if [ -x /etc/init.d/cron ]
then
   /etc/init.d/cron restart
fi
