#!/bin/bash
#
# This script sets up the cron log and permissions for GEN003160 and GEN003180
#

FILE=/var/log/cron

if [ -f $FILE ]
then
   chmod 600 $FILE
else
   touch $FILE
   chmod 600 $FILE
fi

SYSLOGNG=/etc/syslog-ng/syslog-ng.conf

if [ -f $SYSLOGNG ]
then
   CRONCHECK1=`egrep -c "destination cron" $SYSLOGNG`
   CRONCHECK2=`egrep -c "log.*f_cron" $SYSLOGNG`

   if [ $CRONCHECK1 -ne 0 ]
   then
      grep '^#destination cron' $SYSLOGNG > /dev/null
      if [ $? -eq 0 ]
      then
         sed -i "/^#destination cron/ c\destination cron { file(\"/var/log/cron\" perm(0600)); };" $SYSLOGNG
      else
         sed -i "/^[^#]*destination cron/ c\destination cron { file(\"/var/log/cron\" perm(0600)); };" $SYSLOGNG
      fi
   fi

   if [ $CRONCHECK2 -ne 0 ]
   then
      grep '^#log.*f_cron' $SYSLOGNG > /dev/null
      if [ $? -eq 0 ]
      then
         sed -i "/^#log.*f_cron/ c\log { source(src); filter(f_cron); destination(cron); };" $SYSLOGNG
      else
         sed -i "/^[^#]*log.*f_cron/ c\log { source(src); filter(f_cron); destination(cron); };" $SYSLOGNG
      fi
   fi
fi

SYSLOGR=/etc/rsyslog.conf

if [ -f $SYSLOGR ]
then
   CRONLOGR=$( grep 'cron.*' $SYSLOGR | grep -c /var/log/cron )
   if [ $CRONLOGR -eq 0 ]
   then
      echo "#
# cron log entries for GEN003160
#
cron.*                                  -/var/log/cron
" >> $SYSLOGR
   fi
fi

if [ -x /etc/init.d/cron ]
then
   /etc/init.d/cron restart
fi
