#!/bin/bash
#

FILE=/var/log/auth.log

if [ -f $FILE ]
then
   chmod 600 /var/log/auth.log
else
   touch /var/log/auth.log
   chmod 600 /var/log/auth.log
fi

SYSLOGNG=/etc/syslog-ng/syslog-ng.conf

if [ -f $SYSLOGNG ]
then
   AUTHLOG=$( egrep -c 'auth.log' $SYSLOGNG )

   if [ $AUTHLOG -eq 0 ]
   then
      echo "
filter f_auth { facility(auth); };
filter f_authpriv { facility(auth, authpriv); };

destination authlog { file(\"/var/log/auth.log\" perm(0600)); };
log { source(src); filter(f_auth); destination(authlog); };
log { source(src); filter(f_authpriv); destination(authlog); };
" >> $SYSLOGNG
   fi
fi

SYSLOGR=/etc/rsyslog.conf

if [ -f $SYSLOGR ]
then
   AUTHLOGR=$( grep 'auth.*' $SYSLOGR | grep -c /var/log/auth.log )
   if [ $AUTHLOGR -eq 0 ]
   then
      echo "#
# auth.log entries for GEN003660
#
auth.*					-/var/log/auth.log
" >> $SYSLOGR
   fi
fi

/etc/init.d/cron restart
