#!/bin/bash
#

if [ -e /etc/xinetd.conf ]
then
   sed -i "/^[^#]*log_type/ c\\\\tlog_type\t= SYSLOG authpriv" /etc/xinetd.conf
   sed -i "/^[^#]*log_on_success/ c\\\\tlog_on_success\t= HOST PID USERID EXIT" /etc/xinetd.conf
   sed -i "/^[^#]*log_on_failure/ c\\\\tlog_on_failure\t= HOST USERID" /etc/xinetd.conf
fi

FILES1="\
/etc/xinetd.d/chargen
/etc/xinetd.d/chargen-udp
/etc/xinetd.d/daytime
/etc/xinetd.d/daytime-udp
/etc/xinetd.d/discard
/etc/xinetd.d/discard-udp
/etc/xinetd.d/echo
/etc/xinetd.d/echo-udp
/etc/xinetd.d/servers
/etc/xinetd.d/services
/etc/xinetd.d/time-udp"

for i in $FILES1
do
   if [ -e $i ]
   then
      XLOG=$( egrep -c 'log_type' $i )
      if [ $XLOG -ne 0 ]
      then
         sed -i "/^[^#]*log_type/ c\\\\tlog_type\t= SYSLOG authpriv" $i
      else
         sed -i "5a\\\tlog_type = SYSLOG authpriv" $i
      fi

      XLOG1=$( egrep -c 'log_on_success' $i )
      if [ $XLOG1 -ne 0 ]
      then
         sed -i "/^[^#]*log_on_success/ c\\\\tlog_on_success\t= HOST PID USERID EXIT" $i
      else
         sed -i "6a\\\tlog_on_success = HOST PID USERID EXIT" $i
      fi

      XLOG2=$( egrep -c 'log_on_failure' $i )
      if [ $XLOG2 -ne 0 ]
      then
         sed -i "/^[^#]*log_on_failure/ c\\\\tlog_on_failure\t= HOST USERID" $i
      else
         sed -i "7a\\\tlog_on_failure = HOST USERID" $i
      fi
   fi
done

FILES2="/etc/xinetd.d/netstat"

for i in $FILES2
do
   if [ -e $i ]
   then
      XLOG=$( egrep -c 'log_type' $i )
      if [ $XLOG -ne 0 ]
      then
         sed -i "/^[^#]*log_type/ c\\\\tlog_type\t= SYSLOG authpriv" $i
      else
         sed -i "7a\\\tlog_type = SYSLOG authpriv" $i
      fi

      XLOG1=$( egrep -c 'log_on_success' $i )
      if [ $XLOG1 -ne 0 ]
      then
         sed -i "/^[^#]*log_on_success/ c\\\\tlog_on_success\t= HOST PID USERID EXIT" $i
      else
         sed -i "8a\\\tlog_on_success = HOST PID USERID EXIT" $i
      fi

      XLOG2=$( egrep -c 'log_on_failure' $i )
      if [ $XLOG2 -ne 0 ]
      then
         sed -i "/^[^#]*log_on_failure/ c\\\\tlog_on_failure\t= HOST USERID" $i
      else
         sed -i "9a\\\tlog_on_failure = HOST USERID" $i
      fi
   fi
done

FILES3="/etc/xinetd.d/systat"

for i in $FILES3
do
   if [ -e $i ]
   then
      XLOG=$( egrep -c 'log_type' $i )
      if [ $XLOG -ne 0 ]
      then
         sed -i "/^[^#]*log_type/ c\\\\tlog_type\t= SYSLOG authpriv" $i
      else
         sed -i "8a\\\tlog_type = SYSLOG authpriv" $i
      fi

      XLOG1=$( egrep -c 'log_on_success' $i )
      if [ $XLOG1 -ne 0 ]
      then
         sed -i "/^[^#]*log_on_success/ c\\\\tlog_on_success\t= HOST PID USERID EXIT" $i
      else
         sed -i "9a\\\tlog_on_success = HOST PID USERID EXIT" $i
      fi

      XLOG2=$( egrep -c 'log_on_failure' $i )
      if [ $XLOG2 -ne 0 ]
      then
         sed -i "/^[^#]*log_on_failure/ c\\\\tlog_on_failure\t= HOST USERID" $i
      else
         sed -i "10a\\\tlog_on_failure = HOST USERID" $i
      fi
   fi
done

FILES4="/etc/xinetd.d/time"

for i in $FILES4
do
   if [ -e $i ]
   then
      XLOG=$( egrep -c 'log_type' $i )
      if [ $XLOG -ne 0 ]
      then
         sed -i "/^[^#]*log_type/ c\\\\tlog_type\t= SYSLOG authpriv" $i
      else
         sed -i "6a\\\tlog_type = SYSLOG authpriv" $i
      fi

      XLOG1=$( egrep -c 'log_on_success' $i )
      if [ $XLOG1 -ne 0 ]
      then
         sed -i "/^[^#]*log_on_success/ c\\\\tlog_on_success\t= HOST PID USERID EXIT" $i
      else
         sed -i "7a\\\tlog_on_success = HOST PID USERID EXIT" $i
      fi

      XLOG2=$( egrep -c 'log_on_failure' $i )
      if [ $XLOG2 -ne 0 ]
      then
         sed -i "/^[^#]*log_on_failure/ c\\\\tlog_on_failure\t= HOST USERID" $i
      else
         sed -i "8a\\\tlog_on_failure = HOST USERID" $i
      fi
   fi
done
