#!/bin/bash
#
# This script removes tcpdump and netcat from the production appliances
# in order to meet product security requirements.
# There is a vmware-gss-support rpm, which bundles tcpdump and netcat
# rpm packages and stores them under /etc/vmware-gss-support on
# target system.
# One can use the provided install script to install those utilites
# while trouble-shooting network problems on the appliance.
# The uninstall script is used to clean up those rpms when debugging
# work has completed.
# Please see bugzilla ticket 1064292 for details.
#

# Check if rpm is installed on the system.
# Value (return code) equals to '1' if rpm is not installed.
# Value (return code) equals to '0' if rpm is installed.
#
# Since vasecurity rpm is set to obsolete tcpdump and netcat,
# skip removing them if vasecurity rpm is in place.
rpm -q --quiet sles_vasecurity > /dev/null
if [ $? -eq 1 ]
then
   rpm -q --quiet tcpdump > /dev/null
   if [ $? -eq 0 ]
   then
      rpm -e tcpdump
   fi
   rpm -q --quiet netcat > /dev/null
   if [ $? -eq 0 ]
   then
      rpm -e netcat
   fi
fi
