#!/bin/bash
#

DIR="/var/log/rpmcheck"

if [ -d "$DIR" ]
then
   chmod 700 $DIR
else
   mkdir -p $DIR
   chmod 700 $DIR
fi

FILE="/etc/cron.weekly/rpmcheck"

if [ -f "$FILE" ]
then
   egrep -e '^*rpmcheck' $FILE > /dev/null
   if [ $? -ne 0 ]
   then
      echo "rpm -qVa | awk '\$2!=\"c\" {print \$0}' > /var/log/rpmcheck/rpmcheck.\$(date +%m%d%Y-%H%M%S)" >> $FILE
   fi
else
   echo "rpm -qVa | awk '\$2!=\"c\" {print \$0}' > /var/log/rpmcheck/rpmcheck.\$(date +%m%d%Y-%H%M%S)" >> $FILE
   chmod 700 $FILE
fi
