#!/bin/bash

rm -rf /etc/audit/audit.rules.STIG

echo "
# This file contains the auditctl rules that are loaded
# whenever the audit daemon is started via the initscripts.
# The rules are simply the parameters that would be passed
# to auditctl.

# First rule - delete all
-D

# Increase the buffers to survive stress events.
# Make this bigger for busy systems
-b 640

# Covers rules for GEN002760,-2,-4,-8,-9,-10
-w /etc/audit/auditd.conf
-w /etc/audit/audit.rules

-a exit,always -F arch=b64 -S settimeofday -S adjtimex -F auid=0
-a exit,always -F arch=b64 -S settimeofday -S adjtimex -F auid>=500 -F auid!=4294967295
-a exit,always -F arch=b64 -S chmod -S fchmod -S chown -S fchown -S fchownat -S fchmodat -F auid=0
-a exit,always -F arch=b64 -S chmod -S fchmod -S chown -S fchown -S fchownat -S fchmodat -F auid>=500 -F auid!=4294967295
-a exit,always -F arch=b64 -S setrlimit -F success!=1 -F exit!=0
-a exit,always -F arch=b64 -S rmdir -F success!=1 -F exit!=0

# Suppress vcva audit logs
-a exit,never -F arch=b64 -S open -F success=1 -F exit=4
-a exit,never -F arch=b64 -S open -F success=1 -F exit=5

# Suppress vcova and Log Insight audit rules
-a exit,never -F arch=b64 -S open -F success=1 -F exit=8
-a exit,never -F arch=b64 -S execve -F success=1 -F exit=0

# GEN002740,-2
-a exit,always -F arch=b32 -S rmdir
-a exit,always -F arch=b64 -S unlink -S unlinkat -S rename -S renameat -F auid=0
-a exit,always -F arch=b64 -S unlink -S unlinkat -S rename -S renameat -F auid>=500 -F auid!=4294967295
-a exit,always -F arch=b32 -S unlink -S unlinkat -S rename -S renameat -F auid=0
-a exit,always -F arch=b32 -S unlink -S unlinkat -S rename -S renameat -F auid>=500 -F auid!=4294967295

-a exit,always -F arch=b32 -S stime -S acct -S reboot -S settimeofday -S setrlimit -S setdomainname -S sched_setparam -S sched_setscheduler
-a exit,always -F arch=b64 -S acct -S reboot -S setdomainname -S sched_setparam -S sched_setscheduler

-a exit,always -F arch=b64 -S swapon -F exit=-EPERM
-a exit,always -F arch=b64 -S swapon -F exit=-EACCES
-a exit,always -F arch=b32 -S swapon -F exit=-EPERM
-a exit,always -F arch=b32 -S swapon -F exit=-EACCES

# GEN002720
-a exit,always -F arch=b64 -S creat -F exit=-EPERM
-a exit,always -F arch=b64 -S creat -F exit=-EACCES
-a exit,always -F arch=b32 -S creat -F exit=-EPERM
-a exit,always -F arch=b32 -S creat -F exit=-EACCES

# GEN002720-2
-a exit,always -F arch=b64 -S open -F exit=-EPERM
-a exit,always -F arch=b64 -S open -F exit=-EACCES
-a exit,always -F arch=b32 -S open -F exit=-EPERM
-a exit,always -F arch=b32 -S open -F exit=-EACCES

# GEN002720-3
-a exit,always -F arch=b64 -S openat -F success=0 -F exit!=-2
-a exit,always -F arch=b32 -S openat -F success=0

# GEN002720-4
-a exit,always -F arch=b64 -S truncate -F success=0
-a exit,always -F arch=b32 -S truncate -F success=0

# GEN002720-5
-a exit,always -F arch=b64 -S ftruncate -F success=0
-a exit,always -F arch=b32 -S ftruncate -F success=0

# GEN002750
-w /usr/sbin/useradd -p x -k useradd
-w /usr/sbin/groupadd -p x -k groupadd
-w /etc/passwd -p a -k passwd
-w /etc/shadow -p a -k shadow
-w /etc/group -p a -k group
-w /etc/security/opasswd -p a -k opasswd

# GEN002751
-w /usr/sbin/usermod -p x -k usermod
-w /usr/sbin/groupmod -p x -k groupmod
-w /etc/passwd -p w -k passwd
-w /etc/shadow -p w -k shadow
-w /etc/group -p w -k group
-w /etc/security/opasswd -p w -k opasswd

# GEN002752
-w /usr/bin/passwd -p x -k passwd

# GEN002753
-w /usr/sbin/userdel -p x -k userdel
-w /usr/sbin/groupdel -p x -k groupdel

# GEN002760-3,-6,-7, GEN002820,-2-13, GEN002825,-1-5
-a exit,always -F arch=b64 -S clock_settime -S sethostname -S lchown -S setxattr -S lsetxattr -S fsetxattr -S removexattr -S lremovexattr -S fremovexattr -S init_module -S delete_module
-a exit,always -F arch=b32 -S adjtimex -S clock_settime -S sethostname -S chmod -S fchmod -S fchmodat -S chown -S chown32 -S fchown -S fchown32 -S fchownat -S lchown -S lchown32 -S setxattr -S lsetxattr -S fsetxattr -S removexattr -S lremovexattr -S fremovexattr -S init_module -S delete_module

# GEN002800
-w /var/log/faillog -p wa
-w /var/log/lastlog -p wa
-w /var/log/tallylog -p wa

# GEN002825-3
-w /sbin/insmod -p x

# GEN002825-4
-w /sbin/modprobe -p x

# GEN002825-5
-w /sbin/rmmod -p x

# CCI-000169
-w /etc/localtime -p wa -k localtime

# CCI-000172
-w /etc/sudoers -p wa -k sudoers
" >> /etc/audit/audit.rules.STIG
chmod 640 /etc/audit/audit.rules.STIG

# CCI-000040
/usr/bin/find / -xdev \( -perm -4000 -o -perm -2000 \) -type f 2>/dev/null | awk '{print "-a exit,always -F path="$1" -F perm=x -F auid>=500 -k privileged" }' >> /etc/audit/audit.rules.STIG
