#!/bin/bash
# This script creates the DoD banners, enables DoD audit requirements,
# sets the minimum password length to 14, and adds mesg n to profile scripts
#

if [ -f /etc/dodscript.sh ]
then
   rm -rf /etc/dodscript.sh
   touch /etc/dodscript.sh
else
   touch /etc/dodscript.sh
fi

echo "#!/bin/bash
WELCOMEBANNER=\"/opt/vmware/etc/isv/welcometext\"
WELCOMEBANNERDOD=\"/opt/vmware/etc/isv/welcometextDoD\"
WELCOMEBANNERORIG=\"/opt/vmware/etc/isv/welcometextORIG\"
WELCOMEBANNERTEMPLATE=\"/opt/vmware/etc/isv/welcometext.template\"
WELCOMEBANNERTEMPLATEORIG=\"/opt/vmware/etc/isv/welcometext.template.ORIG\"

if [ -f \$WELCOMEBANNERORIG ]
then
   rm -rf \$WELCOMEBANNER
   ln -s \$WELCOMEBANNERDOD \$WELCOMEBANNER
elif [ -f \$WELCOMEBANNERTEMPLATE ]
then
   cp \$WELCOMEBANNERTEMPLATE \$WELCOMEBANNERTEMPLATEORIG
   cp \$WELCOMEBANNERDOD \$WELCOMEBANNERTEMPLATE
   cp \$WELCOMEBANNERTEMPLATE \$WELCOMEBANNER
else
   mv \$WELCOMEBANNER \$WELCOMEBANNERORIG
   ln -s \$WELCOMEBANNERDOD \$WELCOMEBANNER
fi

AUDIT=\"/etc/audit/audit.rules\"
AUDITDOD=\"/etc/audit/audit.rules.STIG\"
AUDITORIG=\"/etc/audit/audit.rules.ORIG\"

if [ -f \$AUDITORIG ]
then
   rm -rf \$AUDIT
   ln -s \$AUDITDOD \$AUDIT
else
   mv \$AUDIT \$AUDITORIG
   ln -s \$AUDITDOD \$AUDIT
fi

sed -i '/^[^#]*AUDITD_DISABLE_CONTEXTS/ c\\AUDITD_DISABLE_CONTEXTS=\"no\"' /etc/sysconfig/auditd

service auditd restart

ISSUE=\"/etc/issue\"
ISSUEDOD=\"/etc/issue.DoD\"
ISSUEORIG=\"/etc/issue.ORIG\"

if [ -f \$ISSUEORIG ]
then
   rm -rf \$ISSUE
   ln -s \$ISSUEDOD \$ISSUE
else
   mv \$ISSUE \$ISSUEORIG
   ln -s \$ISSUEDOD \$ISSUE
fi

FILE=/etc/login.defs

grep '^[#]*PASS_MIN_LEN' \$FILE > /dev/null
if [ \$? -ne 0 ]
then
   echo \"PASS_MIN_LEN   14\" >> \$FILE
else
   sed -i \"/^[^#]*PASS_MIN_LEN/ c\PASS_MIN_LEN   14\" \$FILE
fi

sed -i \"/minlen=/s/8/14/\" /etc/pam.d/common-password-vmware.local

for MESGFILES in /etc/bash.bashrc /etc/csh.cshrc /etc/csh.login /etc/environment /etc/ksh.kshrc /etc/profile /etc/zshrc /etc/profile.d/*
do
  if [ -f \$MESGFILES ]
  then
    grep 'mesg n' \$MESGFILES > /dev/null
    if [ \$? -ne 0 ]
    then
      echo \"\" >> \$MESGFILES
      echo \"mesg n 2>/dev/null\" >> \$MESGFILES
    fi
  fi
done
" >> /etc/dodscript.sh
chown root:root /etc/dodscript.sh
chmod 700 /etc/dodscript.sh
