#!/bin/bash
#
# This script sets the /etc/permisssions.local file entry to enforce permission changes upon SuSEconfig execution
#
PERMLOCAL="/etc/permissions.local"

if [ -f $PERMLOCAL ]
then
  rm -rf $PERMLOCAL
fi
echo "
#
# /etc/permissions.local
#
# This file is used by SuSEconfig and chkstat to check or set the modes
# and ownerships of files and directories in the installation.
#
# In particular, this file will not be touched during an upgrade of the
# SuSE Linux installation. It is designed to be a placeholder for local
# additions by the administrator of the system to reflect filemodes
# of locally installed packages or to override file permissions as
# shipped with the distribution.
#
# Format:
# <file> <owner>:<group> <permission>
#
# Please see the file /etc/permissions for general usage hints of the
# /etc/permissions* files.
# Keep in mind that this file (/etc/permissions.local) is being used by
# default by SuSEconfig, the shell script that is used by yast and yast2
# after package installation and configuration changes to make the changes
# effective for the respective packages (eg generating the "real"
# configuration files).
# Always check if there are no conflicts between your "local" changes here
# and the settings in the other permissions files by calling
# "SuSEconfig" as root!
# Please remember that logfiles might be modified by the logfile
# rotation facilities (e.g. logrotate) so settings entered here might
# be overridden.
# This file needs to end with a newline.
#
# example:
#/usr/bin/sperl5.8.8         root:root       4755
/boot/grub/menu.lst                              root:root                600
/core                                            root:root                700
/dev/urandom                                     root:root                644
/dev/random                                      root:root                644
/etc/aliases                                     root:root                644
/etc/aliases.db                                  root:root                644
/etc/at.allow                                    root:root                600
/etc/at.deny                                     root:root                600
/etc/bash.bashrc                                 root:root                644
/etc/cron.allow                                  root:root                600
/etc/cron.deny                                   root:root                600
/etc/crontab                                     root:root                600
/etc/csh.cshrc                                   root:root                644
/etc/csh.login                                   root:root                644
/etc/environment                                 root:root                644
/etc/exports                                     root:root                644
/etc/fstab                                       root:root                600
/etc/ftpusers                                    root:root                640
/etc/group                                       root:root                644
/etc/hosts                                       root:root                644
/etc/hosts.lpd                                   root:root                644
/etc/ldap.conf                                   root:root                644
/etc/nsswitch.conf                               root:root                644
/etc/ntp.conf                                    root:root                640
/etc/passwd                                      root:root                644
/etc/profile                                     root:root                644
/etc/resolv.conf                                 root:root                644
/etc/rsyslog.conf                                root:root                640
/etc/securetty                                   root:root                600
/etc/security/opasswd                            root:root                600
/etc/shadow                                      root:root                400
/etc/sysctl.conf                                 root:root                600
/etc/syslog-ng/syslog-ng.conf                    root:root                640
/etc/security/access.conf                        root:root                640
/etc/services                                    root:root                644
/etc/skel/.bashrc                                root:root                640
/etc/skel/.emacs                                 root:root                640
/etc/skel/bin                                    root:root                750
/etc/skel/.fonts                                 root:root                750
/etc/skel/.inputrc                               root:root                640
/etc/skel/.profile                               root:root                640
/etc/skel/.vimrc                                 root:root                640
/etc/snmp/snmpd.conf                             root:root                600
/etc/ssh/sshd_config                             root:root                640
/etc/ssh/ssh_config                              root:root                644
/etc/xinetd.conf                                 root:root                440
/etc/xinetd.d                                    root:root                755
/etc/xinetd.d/chargen                            root:root                640
/etc/xinetd.d/chargen-udp                        root:root                640
/etc/xinetd.d/daytime                            root:root                640
/etc/xinetd.d/daytime-udp                        root:root                640
/etc/xinetd.d/discard                            root:root                640
/etc/xinetd.d/discard-udp                        root:root                640
/etc/xinetd.d/echo                               root:root                640
/etc/xinetd.d/echo-udp                           root:root                640
/etc/xinetd.d/netstat                            root:root                640
/etc/xinetd.d/rsync                              root:root                640
/etc/xinetd.d/servers                            root:root                640
/etc/xinetd.d/services                           root:root                640
/etc/xinetd.d/systat                             root:root                640
/etc/xinetd.d/time                               root:root                640
/etc/xinetd.d/time-udp                           root:root                640
/root                                            root:root                700
/root/inst-sys/.vimrc                            root:root                640
/root/inst-sys/.bash_history                     root:root                640
/root/inst-sys/.bash_login                       root:root                640
/root/.kbd/.keymap_sv                            root:root                640
/root/.exrc                                      root:root                640
/sbin/audispd                                    root:root                750
/sbin/auditctl                                   root:root                750
/sbin/auditd                                     root:root                750
/sbin/aureport                                   root:root                750
/sbin/ausearch                                   root:root                750
/sbin/autrace                                    root:root                750
/sbin/mount.nfs                                  root:root                755
/tmp                                             root:root               1777
/usr/bin/crontab                                 root:trusted            4750
/usr/bin/passwd                                  root:root               4755
/usr/bin/wall                                    root:tty                 755
/usr/bin/write                                   root:tty                 755
/usr/lib/sendmail.d/helpfile                     root:root                000
/usr/sbin/pam-config                             root:root                000
/usr/sbin/traceroute                             root:root                700
/usr/sbin/zypp-refresh-wrapper                   root:root                755
/usr/share/vim/vim72/syntax/mib.vim              root:root                640
/var/cache/fonts                                 root:root               1775
/var/crash                                       root:root                700
/var/log/acpid                                   root:root                640
/var/log/allmessages                             root:root                640
/var/log/audit/audit.log                         root:root                600
/var/log/auth.log                                root:root                600
/var/log/btmp                                    root:root                600
/var/log/boot.msg                                root:root                640
/var/log/cron                                    root:root                600
/var/log/faillog                                 root:root                600
/var/log/firewall                                root:root                600
/var/log/lastlog                                 root:tty                 640
/var/log/ldapmessages                            root:root                640
/var/log/localmessages                           root:root                640
/var/log/mail                                    root:root                640
/var/log/mail.err                                root:root                640
/var/log/mail.info                               root:root                640
/var/log/mail.warn                               root:root                640
/var/log/news/news.crit                          root:root                640
/var/log/news/news.err                           root:root                640
/var/log/news/news.notice                        root:root                640
/var/log/messages                                root:root                640
/var/log/NetworkManager                          root:root                640
/var/log/sudolog                                 root:root                600
/var/log/tallylog                                root:root                600
/var/log/warn                                    root:root                640
/var/log/wtmp                                    root:tty                 664
/var/spool/cron                                  root:root                755
/var/spool/mail                                  root:root               1775
/var/spool/postfix/.bashrc                       postfix:postfix          640
/var/spool/postfix/.emacs                        postfix:postfix          640
/var/spool/postfix/.vimrc                        postfix:postfix          640
/var/spool/postfix/.profile                      postfix:postfix          640
/var/spool/postfix/.inputrc                      postfix:postfix          640
/var/spool/cron/lastrun                          root:root                755
/var/spool/cron/lastrun/cron.daily               root:root                600
/var/spool/cron/lastrun/cron.hourly              root:root                600
/var/spool/cron/lastrun/cron.weekly              root:root                600
/var/spool/cron/lastrun/cron.monthly             root:root                600
" >> $PERMLOCAL
chmod 644 $PERMLOCAL
