#!/bin/bash
#
# This PR is to address CVE-2013-5211 for DDoS attack on ntp

if [ -f /etc/ntp.conf ]
then
   FILE=/etc/ntp.conf
   OPTIONS="kod nomodify notrap nopeer noquery"
   RESTRICT4DEFAULT=`cat $FILE | grep -c "restrict default"`
   RESTRICT6DEFAULT=`cat $FILE | grep -c "restrict -6 default"`
   RESTRICT4LOCAL=`cat $FILE | grep restrict | grep -c "127.0.0.1"`
   RESTRICT6LOCAL=`cat $FILE | grep restrict | grep -c "::1"`

   if [ $RESTRICT4DEFAULT -eq 0 ]
   then
      echo "restrict default $OPTIONS" >> $FILE
   else
      sed -i "/^[^#]*restrict default/ c\restrict default $OPTIONS" $FILE
   fi

   if [ $RESTRICT6DEFAULT -eq 0 ]
   then
      echo "restrict -6 default $OPTIONS" >> $FILE
   else
      sed -i "/^[^#]*restrict -6 default/ c\restrict -6 default $OPTIONS" $FILE
   fi

   if [ $RESTRICT4LOCAL -eq 0 ]
   then
      echo "restrict 127.0.0.1" >> $FILE
   fi

   if [ $RESTRICT6LOCAL -eq 0 ]
   then
      echo "restrict -6 ::1" >> $FILE
   fi

   NTPSTOP=`chkconfig ntp | grep -c off`
   if [ $NTPSTOP -eq 0 ]
   then
      service ntp restart
   fi
fi
