#!/bin/bash
# Weak Encryption Ciphers are in Use for VAMI lighttpd
#
# Usage: VMW-BZ-744580 [lighttpd.conf] [parameter] [value] [parameter_section]
set -e

trap Clean_up HUP INT QUIT TERM ERR EXIT

SCRIPT_NAME=$(basename "${0%.sh}")

LIGHTTPD_CONF=${1:-"/opt/vmware/etc/lighttpd/lighttpd.conf"}
PARAM=${2:-"ssl.cipher-list"}
VALUE=${3:-"!aNULL:kECDH+AESGCM:ECDH+AESGCM:RSA+AESGCM"}
SECTION=${4:-"ssl"}

if [ ! -f "${LIGHTTPD_CONF}" ]; then
   echo "${SCRIPT_NAME}:WARNING: No ${LIGHTTPD_CONF} found" >&2
   exit -1
fi

# copy original file to temp file
TMPFILE=$(mktemp)
cp ${LIGHTTPD_CONF} ${TMPFILE}

if [ $(grep -v "^#" ${LIGHTTPD_CONF} | grep -c "${PARAM}") -gt 0 ]; then
    sed -i "s|^[ ]*${PARAM}.*|${PARAM} = \"${VALUE}\"|g" ${TMPFILE}
else
    # modify the temp file to remove all section settings
    grep -v "^${SECTION}" ${LIGHTTPD_CONF} > ${TMPFILE}

    # append current section settings to end of file to ensure they are
    # grouped together
    echo "#### VMware ${SECTION}" >> ${TMPFILE}
    grep "^${SECTION}" ${LIGHTTPD_CONF} >> ${TMPFILE}
    # append new parameter to section
    echo "${PARAM} = \"${VALUE}\"" >> ${TMPFILE}

fi
chmod 600 ${TMPFILE}
mv ${TMPFILE} ${LIGHTTPD_CONF}

