#!/bin/bash
#
# The nodev option prevents users from mounting unauthorized devices on any
# partition which is known not to contain any authorized devices. The root
# partition typically contains the /dev directory, which is the primary
# location for authorized devices, so this option should not be set on /.
#
# Usage: VMW-BZ-779559 [fstab]
set -e

trap Clean_up HUP INT QUIT TERM ERR EXIT

SCRIPT_NAME=$(basename "${0%.sh}")

FSTAB=${1:-"/etc/fstab"}

if [ -f "${FSTAB}" ]; then

    TMP=$(mktemp)
    awk '{
        if($3 ~ /(ext2|ext3)/ && $2 != "/" && $4 !~ /nodev/) {
           $4 = $4",nodev";
        }
        print $0;
    }' ${FSTAB} > ${TMP}

    PERM=$(stat -c %a ${FSTAB})
    mv ${TMP} ${FSTAB}
    chmod ${PERM} ${FSTAB}
fi

