#!/bin/bash
# IPv6 sysctl options are not properly enabled since the IPv6 interface is not
# up when the options are read.
set -e

trap Clean_up HUP INT QUIT TERM ERR EXIT

SCRIPT_NAME=$(basename "${0%.sh}")

SYSCTL_BOOT=${1:-"/etc/init.d/boot.sysctl"}

if [ -e $SYSCTL_BOOT ]
then
   # If there are IPv6 options specified in /etc/sysctl.conf and ipv6 is enabled
   IPV6_MODPROBE="grep ^net\\\\\\\.ipv6 \/etc\/sysctl.conf \&\& \/sbin\/modprobe ipv6 >\/dev\/null 2>\&1"
   if [ ! "$(grep "${IPV6_MODPROBE}" ${SYSCTL_BOOT})" ]; then

      # create a temporary copy of configuration file
      TMPFILE=$(mktemp)
      cp ${SYSCTL_BOOT} ${TMPFILE}

      # add in the new line check for IPv6
      sed -i "s|\(.*\)\(sysctl -e -q -p \/etc\/sysctl.conf\)|\1${IPV6_MODPROBE}\n\1\2|" ${TMPFILE}

      # move temporary file to original
      mv ${TMPFILE} ${SYSCTL_BOOT}

      # ensure that permissions are correct
      chmod 755 ${SYSCTL_BOOT}
   fi
fi
